#include "stdafx.h"  //Needed in all .cpp files to prevent error: uafxcwd.lib(afxmem.obj) : error LNK2005: "void * __cdecl operator new(unsigned int)" (??2@YAPAXI@Z) already defined in LIBCMTD.lib(new.obj)

#include "CorrectDng.h"

#include "dng_camera_profile.h"
#include "dng_color_space.h"
#include "dng_date_time.h"
#include "dng_exceptions.h"
#include "dng_file_stream.h"
#include "dng_globals.h"
#include "dng_host.h"
#include "dng_ifd.h"
#include "dng_image_writer.h"
#include "dng_info.h"
#include "dng_linearization_info.h"
#include "dng_mosaic_info.h"
#include "dng_negative.h"
#include "dng_preview.h"
#include "dng_render.h"
#include "dng_simple_image.h"
#include "dng_tag_codes.h"
#include "dng_tag_types.h"
#include "dng_tag_values.h"
#include "dng_xmp.h"
#include "dng_xmp_sdk.h"



bool CorrectDng::ApplyCorrection(CWnd* pWnd, CString& filepath_in, CString& filepath_out)
{
	dng_file_stream stream(filepath_in);
	dng_host host;
	host.SetPreferredSize(0);
	host.SetMinimumSize(0);
	host.SetMaximumSize(0);
	host.ValidateSizes();
	if (host.MinimumSize())
	{
		host.SetForPreview(true);
	}
	host.SetSaveDNGVersion(dngVersion_SaveDefault);
	host.SetSaveLinearDNG(false);
	host.SetKeepOriginalFile(false);

	// Read into the negative.
	AutoPtr<dng_negative> negative;
	dng_info info;
	info.Parse(host, stream);
	info.PostParse(host);
	if (!info.IsValidDNG())
	{
		pWnd->MessageBox(L"Bad format for DNG file", L"Error");
		return false;
	}

	negative.Reset(host.Make_dng_negative());
	negative->Parse(host, stream, info);
	negative->PostParse(host, stream, info);
	negative->ReadStage1Image(host, stream, info);


	uint16* lut;
	int* correctionTable;

	//Obtain camera model and bit depth to select LUT and Correction Table
	const dng_string & cameraModel = negative->ModelName();
	uint32 white_level = negative->WhiteLevel();

	CString model = cameraModel.Get();
	if (white_level > 4096)
	{
		//Assume 14bit mode
		if (model == "Nikon D5100" || model == "Nikon D5200" || model == "Nikon D5300" || model == "Nikon D7000" || model == "Nikon D7100" || model == "Nikon D7500" || 
			model == "Nikon D500"  || model == "Nikon D600"  || model == "Nikon D610"  || model == "Nikon D3S"   || model == "Nikon D3X"   || model == "Nikon D4"    || 
			model == "Nikon D800"  || model == "Nikon D800E" || model == "Nikon D850"  || model == "Nikon Df" )
		{
			lut = mLut1;
			correctionTable = mCorrectionTable1;
		}
		else if (model == "Nikon D5500" || model == "Nikon D5600" || model == "Nikon D7200" || model == "Nikon D750" || model == "Nikon D810")
		{
			lut = mLut2;
			correctionTable = mCorrectionTable2;
		}
		else
		{
			CString mess = "Camera model " + model + " 14-bit correction table not available";
			pWnd->MessageBox(mess, L"Error");
			return false;
		}
	}
	else
	{
		//Assume 12bit mode
		if (model == "Nikon D5000" || model == "Nikon D5100" || model == "Nikon D5200" || model == "Nikon D5300" || model == "Nikon D7000" || model == "Nikon D7100" || model == "Nikon D7500" ||
			model == "Nikon D500"  || model == "Nikon D600"  || model == "Nikon D610"  || model == "Nikon D3S"   || model == "Nikon D3X"   || model == "Nikon D4"    ||
			model == "Nikon D800"  || model == "Nikon D800E" || model == "Nikon D850"  || model == "Nikon Df"    ||
			model == "Nikon 1 V1"  || model == "Nikon 1 J1"  || model == "Nikon D3100" || model == "Nikon D3200" || model == "Nikon D3300")
		{
			lut = mLut3;
			correctionTable = mCorrectionTable3;
		}
		else
		{
			CString mess = "Camera model " + model + " 12-bit correction table not available";
			pWnd->MessageBox(mess, L"Error");
			return false;
		}
	}

	//If a linearization table exists then the file is losslessy compressed
	//Therefore apply the table of corrections
	const dng_linearization_info *linear_info = negative->GetLinearizationInfo();
	if (linear_info->fLinearizationTable.Get())
	{
		const uint16* dng_lut = linear_info->fLinearizationTable->Buffer_uint16();  //Never used

		//We now access and fix the image data
		dng_simple_image *stage1 = (dng_simple_image *)negative->Stage1Image();

		int width = stage1->Bounds().W();
		int height = stage1->Bounds().H();

		dng_pixel_buffer pixel_buffer;
		stage1->GetPixelBuffer(pixel_buffer);

		for (int row = 0; row < height; row++)
		{
			for (int col = 0; col < width; col++)
			{
				uint16* fred = pixel_buffer.DirtyPixel_uint16(row, col);
				*fred = lut[*fred];
				*fred = *fred - correctionTable[*fred];
			}
		}

		//Now destroy the LUT within the negative
		AutoPtr<dng_memory_block> lut_null = AutoPtr<dng_memory_block>();
		negative->SetLinearization(lut_null);
	}

	if (info.fMaskIndex != -1)
	{
		negative->ReadTransparencyMask(host, stream, info);
	}
	negative->ValidateRawImageDigest(host);

	// Metadata.
	negative->SynchronizeMetadata();

	// Four color Bayer option.
	bool gFourColorBayer = false;
	if (gFourColorBayer)
	{
		negative->SetFourColorBayer();
	}

	// Build stage 2 image.
	negative->BuildStage2Image(host);


	// Build stage 3 image.
	int32 gMosaicPlane = -1;
	negative->BuildStage3Image(host,
		gMosaicPlane);

	// Flatten transparency, if required.
	if (negative->NeedFlattenTransparency(host))
	{
		negative->FlattenTransparency(host);
	}



	// Build the preview list.
	dng_preview_list previewList;
	dng_date_time_info dateTimeInfo;

	CurrentDateTimeAndZone(dateTimeInfo);

	for (uint32 previewIndex = 0; previewIndex < 2; previewIndex++)
	{
		// Skip preview if writing a compresssed main image to save space
		// in this example code.
		if (negative->RawJPEGImage() != NULL && previewIndex > 0)
		{
			break;
		}

		// Render a preview sized image.
		AutoPtr<dng_image> previewImage;


		dng_render render(host, *negative);
		render.SetFinalSpace(negative->IsMonochrome() ? dng_space_GrayGamma22::Get()
			: dng_space_sRGB::Get());
		render.SetFinalPixelType(ttByte);
		render.SetMaximumSize(previewIndex == 0 ? 256 : 1024);
		previewImage.Reset(render.Render());

		// Don't write the preview if it is same size as thumbnail.
		if (previewIndex > 0 &&
			Max_uint32(previewImage->Bounds().W(),
			previewImage->Bounds().H()) <= 256)
		{
			break;
		}

		// If we have compressed JPEG data, create a compressed thumbnail.  Otherwise
		// save a uncompressed thumbnail.
		bool useCompressedPreview = (negative->RawJPEGImage() != NULL) ||
			(previewIndex > 0);

		AutoPtr<dng_preview> preview(useCompressedPreview ?
			(dng_preview*) new dng_jpeg_preview :
			(dng_preview*) new dng_image_preview);

		// Setup up preview info.
		preview->fInfo.fApplicationName.Set("dng_validate");
		//#define kDNGValidateVersion "1.4"
		preview->fInfo.fApplicationVersion.Set("1.4");

		preview->fInfo.fSettingsName.Set("Default");

		preview->fInfo.fColorSpace = previewImage->Planes() == 1 ?
		previewColorSpace_GrayGamma22 :
									  previewColorSpace_sRGB;

		preview->fInfo.fDateTime = dateTimeInfo.Encode_ISO_8601();

		if (!useCompressedPreview)
		{
			dng_image_preview* imagePreview = dynamic_cast<dng_image_preview*> (preview.Get());
			imagePreview->fImage.Reset(previewImage.Release());
		}
		else
		{
			dng_jpeg_preview* jpegPreview = dynamic_cast<dng_jpeg_preview*> (preview.Get());
			int32 quality = (previewIndex == 0 ? 8 : 5);
			dng_image_writer writer;
			writer.EncodeJPEGPreview(host,
				*previewImage,
				*jpegPreview,
				quality);
		}
		previewList.Append(preview);
	}

	// Write DNG file.
	try
	{
		dng_file_stream stream2(filepath_out, true);
		dng_image_writer writer;

		writer.WriteDNG(host,
			stream2,
			*negative.Get(),
			&previewList,
			dngVersion_Current,
			false);
	}
	catch (...)
	{
		pWnd->MessageBox(L"Unable to write to destination file - maybe it is open in another app.", L"Error");
		return false;
	}
	return true;
}

CorrectDng::CorrectDng()
{
	//This initialization can't go in the header file because of a known VS2013 limitation
	int correctionTable1[16384] =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1,
		1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1,
		1, 1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1,
		-1, -1, -1, -2, -2, -2, -2, -3, -3, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
		-1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2,
		-2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2,
		-2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5,
		-5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4,
		-4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2,
		-2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2,
		-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 1, 1,
		1, 1, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6,
		7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 12, 12, 12, 12, 13,
		13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
		16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14,
		14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
		13, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 11,
		11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6,
		6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6,
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
		7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9,
		9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
		11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
		12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14,
		14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16,
		16, 15, 15, 15, 15, 14, 14, 14, 14, 14, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12,
		12, 12, 12, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7,
		6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3,
		3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, -2, -2, -2, -2, -2,
		-2, -2, -2, -2, -3, -3, -3, -3, -3, -4, -4, -4, -4, -5, -5, -5, -5, -6, -6, -6,
		-6, -6, -7, -7, -7, -7, -8, -8, -8, -8, -9, -9, -9, -9, -9, -10, -10, -10, -10, -11,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -14,
		-14, -14, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10,
		-10, -10, -10, -10, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -6,
		-6, -6, -6, -6, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -2,
		-2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,
		-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -6,
		-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -14,
		-14, -14, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10,
		-10, -10, -10, -10, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -6,
		-6, -6, -6, -6, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -2,
		-2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,
		-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -6,
		-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -14,
		-14, -14, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10,
		-10, -10, -10, -10, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -6,
		-6, -6, -6, -6, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -2,
		-2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2,
		2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,
		-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -6,
		-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12,
		-13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10,
		-10, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -5, -5, -5, -5,
		-5, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0,
		0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 5, 5,
		5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5,
		5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5,
		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,
		3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
		1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
		-3, -3, -3, -3, -3, -6, -6, -6, -6, -6, -9, -9, -9, -9, -9, -9, -11, -11, -11, -11,
		-11, -11, -13, -13, -13, -13, -13, -13, -15, -15, -15, -15, -15, -15, -17, -17, -17, -17, -17, -17,
		-18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16,
		-16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14,
		-14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5,
		-5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7,
		-7, -7, -9, -9, -9, -9, -9, -9, -11, -11, -11, -11, -11, -11, -13, -13, -13, -13, -13, -13,
		-15, -15, -15, -15, -15, -15, -17, -17, -17, -17, -17, -17, -18, -18, -18, -18, -18, -18, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13,
		-13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11,
		-11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4,
		-4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -3, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9,
		-11, -11, -11, -11, -11, -11, -13, -13, -13, -13, -13, -13, -15, -15, -15, -15, -15, -15, -17, -17,
		-17, -17, -17, -17, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17,
		-17, -17, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15,
		-14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12,
		-12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10,
		-10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -5, -5,
		-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -11, -11, -11, -11, -11, -11, -13, -13,
		-13, -13, -13, -13, -15, -15, -15, -15, -15, -15, -17, -17, -17, -17, -17, -17, -18, -18, -18, -18,
		-18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16,
		-15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -13, -13,
		-13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
		-5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7, -7, -7, -9, -9,
		-9, -9, -9, -9, -11, -11, -11, -11, -11, -11, -13, -13, -13, -13, -13, -13, -15, -15, -15, -15,
		-15, -15, -17, -17, -17, -17, -17, -17, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17,
		-17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15,
		-15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13,
		-13, -13, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11,
		-10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8,
		-8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6,
		-6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5,
		-5, -5, -5, -5, -7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -11, -11, -11, -11,
		-11, -11, -13, -13, -13, -13, -13, -13, -15, -15, -15, -15, -15, -15, -17, -17, -17, -17, -17, -17,
		-18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16,
		-16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14,
		-14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5,
		-5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7,
		-7, -7, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -12, -12, -12, -12, -12,
		-12, -14, -14, -14, -14, -14, -14, -16, -16, -16, -16, -16, -16, -17, -17, -17, -17, -17, -17, -16,
		-16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -14, -14, -14,
		-14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
		-5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
		-2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, -1, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7,
		-7, -7, -7, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10, -10, -10, -12, -12, -12, -12, -12,
		-12, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14,
		-14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -12, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4,
		-4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2,
		-2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0,
		1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1,
		-1, -1, -1, -1, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6,
		-6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -9, -9,
		-9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -12,
		-12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14,
		-15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -17, -17, -17, -17, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14,
		-14, -14, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9,
		-9, -9, -9, -7, -7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4,
		-4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 1, 1,
		1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0,
		0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2,
		-3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5,
		-5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8,
		-8, -8, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11,
		-11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14,
		-14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -17, -17,
		-17, -17, -17, -17, -17, -18, -18, -18, -18, -18, -18, -18, -19, -19, -19, -19, -19, -19, -19, -20,
		-20, -20, -20, -20, -20, -20, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21,
		-19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -16, -16, -16, -16, -16, -16,
		-16, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11, -11,
		-11, -11, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
		-6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2,
		-2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5,
		-5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -8,
		-8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10,
		-11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13,
		-13, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16,
		-16, -16, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10,
		-10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7, -7, -7, -7, -5, -5,
		-5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, 0,
		0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
		1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1,
		-1, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4,
		-4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7,
		-7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10,
		-10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -13, -13,
		-13, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -16,
		-16, -16, -16, -16, -16, -16, -17, -17, -17, -17, -17, -17, -17, -18, -18, -18, -18, -18, -18, -18,
		-19, -19, -19, -19, -19, -19, -19, -20, -20, -20, -20, -20, -20, -20, -21, -21, -21, -21, -21, -21,
		-21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18,
		-18, -18, -16, -16, -16, -16, -16, -16, -16, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13,
		-13, -13, -13, -11, -11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8,
		-8, -8, -8, -8, -6, -6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -3, -3,
		-3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4,
		-4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6,
		-7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9,
		-9, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12,
		-12, -12, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15,
		-15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17,
		-17, -17, -17, -17, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -12, -12,
		-12, -12, -12, -12, -12, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4,
		-2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
		1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
		0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3,
		-3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6,
		-6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -9, -9,
		-9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -12,
		-12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14,
		-15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -17, -17, -17, -17, -17, -17,
		-17, -18, -18, -18, -18, -18, -18, -18, -19, -19, -19, -19, -19, -19, -19, -20, -20, -20, -20, -20,
		-20, -20, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -16, -16, -16, -16, -16, -16, -16, -14, -14, -14,
		-14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11, -11, -11, -11, -9, -9,
		-9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6, -6, -6, -6, -4,
		-4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2,
		-3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5,
		-5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8,
		-8, -8, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11,
		-11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14,
		-14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15, -15, -15, -15, -14,
		-14, -14, -14, -14, -14, -14, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10, -10, -10, -10, -10,
		-9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5,
		-5, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0,
		0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
		1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2,
		-2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5,
		-5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -8,
		-8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10,
		-11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13,
		-13, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16,
		-16, -16, -17, -17, -17, -17, -17, -17, -17, -18, -18, -18, -18, -18, -18, -18, -19, -19, -19, -19,
		-19, -19, -19, -20, -20, -20, -20, -20, -20, -20, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21,
		-21, -21, -21, -21, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -16, -16,
		-16, -16, -16, -16, -16, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8,
		-6, -6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3,
		-3, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4,
		-4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6,
		-6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2,
		-2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -10, -10, -10, -10, -10, -10, -10, -10, -10, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -24, -24, -24, -24, -24, -24, -24, -24, -24, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26,
		-26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24,
		-23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21,
		-21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17,
		-17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15,
		-15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12,
		-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4,
		-4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2,
		-2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
		2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -9, -9, -9, -9, -9, -9, -9, -9, -9, -16,
		-16, -16, -16, -16, -16, -16, -16, -16, -23, -23, -23, -23, -23, -23, -23, -23, -23, -26, -26, -26,
		-26, -26, -26, -26, -26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24,
		-24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22,
		-22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20,
		-19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13,
		-13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11,
		-11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6,
		-6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4,
		-4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -6, -6, -6, -6, -6, -6, -6,
		-6, -6, -13, -13, -13, -13, -13, -13, -13, -13, -13, -20, -20, -20, -20, -20, -20, -20, -20, -20,
		-27, -27, -27, -27, -27, -27, -27, -27, -27, -30, -30, -30, -30, -30, -30, -30, -30, -30, -29, -29,
		-29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -25, -25, -25, -25,
		-25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23,
		-23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20,
		-20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18,
		-18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16,
		-16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14,
		-14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5,
		-5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, -2, -2, -2,
		-2, -2, -2, -2, -2, -2, -9, -9, -9, -9, -9, -9, -9, -9, -9, -16, -16, -16, -16, -16,
		-16, -16, -16, -16, -23, -23, -23, -23, -23, -23, -23, -23, -23, -26, -26, -26, -26, -26, -26, -26,
		-26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24,
		-23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21,
		-21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17,
		-17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15,
		-15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5,
		-5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3,
		-3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -5, -5, -5, -5, -5, -5, -5, -5, -5, -12,
		-12, -12, -12, -12, -12, -12, -12, -12, -19, -19, -19, -19, -19, -19, -19, -19, -19, -26, -26, -26,
		-26, -26, -26, -26, -26, -26, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28,
		-28, -28, -28, -28, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26,
		-26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24,
		-23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21,
		-21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17,
		-17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15,
		-15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12,
		-12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8,
		-8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6,
		-6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, -8, -8, -8, -8, -8, -8, -8, -8, -8, -15, -15, -15, -15, -15, -15, -15, -15,
		-15, -22, -22, -22, -22, -22, -22, -22, -22, -22, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24,
		-24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22,
		-22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20,
		-20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18,
		-18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16,
		-15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13,
		-13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9,
		-9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4,
		-4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2,
		-2, -2, -2, -2, -2, -2, -5, -5, -5, -5, -5, -5, -5, -5, -5, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -19, -19, -19, -19, -19, -19, -19, -19, -19, -26, -26, -26, -26, -26, -26, -26,
		-26, -26, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28,
		-27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25,
		-25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21,
		-21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19,
		-19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16,
		-16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14,
		-14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12,
		-12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5,
		-5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
		1, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -15, -15, -15, -15, -15, -15, -15, -15, -15, -22, -22, -22,
		-22, -22, -22, -22, -22, -22, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24,
		-24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22,
		-22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20,
		-19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -13,
		-13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10, -10, -10, -10, -10,
		-10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6, -6, -6, -6,
		-6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2,
		-2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -15, -15, -15, -15, -15, -15, -15, -15,
		-15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17,
		-23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25,
		-23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21,
		-19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16,
		-16, -16, -16, -16, -16, -16, -16, -16, -16, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -12,
		-12, -12, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -4,
		-4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3,
		3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -5, -5,
		-5, -5, -5, -5, -5, -5, -5, -5, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -17, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18,
		-18, -18, -18, -18, -18, -18, -18, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -14, -14, -14,
		-14, -14, -14, -14, -14, -14, -14, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10,
		-10, -10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6,
		-6, -6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3,
		-3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1,
		1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7,
		-7, -7, -7, -7, -7, -7, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -27, -27, -27, -27,
		-27, -27, -27, -27, -27, -27, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -19, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -13, -13,
		-13, -13, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14,
		-19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -24, -24, -24, -24, -24, -24, -24, -24, -24,
		-24, -24, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -30, -30, -30, -30, -30, -30, -30,
		-30, -30, -30, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -25, -25, -25, -25, -25, -25,
		-25, -25, -25, -25, -25, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -19, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -13, -13,
		-13, -13, -13, -13, -13, -13, -13, -13, -13, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17,
		-17, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -27, -27, -27, -27, -27, -27, -27, -27,
		-27, -27, -27, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -25, -25, -25, -25, -25, -25,
		-25, -25, -25, -25, -25, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -19, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -14, -14, -14,
		-14, -14, -14, -14, -14, -14, -14, -14, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
		-9, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -19, -19, -19, -19, -19, -19, -19, -19,
		-19, -19, -19, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -25, -25, -25, -25, -25, -25,
		-25, -25, -25, -25, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -20, -20, -20, -20, -20,
		-20, -20, -20, -20, -20, -20, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -14, -14, -14,
		-14, -14, -14, -14, -14, -14, -14, -14, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -8,
		-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
		-5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -22, -22, -22, -22, -22, -22, -22,
		-22, -22, -22, -22, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -20, -20, -20, -20, -20,
		-20, -20, -20, -20, -20, -20, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -14, -14, -14,
		-14, -14, -14, -14, -14, -14, -14, -14, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -4,
		-4, -4, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -14, -14, -14, -14, -14, -14, -14,
		-14, -14, -14, -14, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -20, -20, -20, -20, -20,
		-20, -20, -20, -20, -20, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -15, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -9, -9,
		-9, -9, -9, -9, -9, -9, -9, -9, -9, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
		-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6, -6, -6, -6, -6, -6, -6,
		-6, -6, -6, -6, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -16, -16, -16, -16, -16,
		-16, -16, -16, -16, -16, -16, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -26, -26, -26,
		-26, -26, -26, -26, -26, -26, -26, -26, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -36,
		-36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -37, -37, -37, -37, -37, -37, -37, -37, -37, -37,
		-37, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -34, -31, -31, -31, -31, -31, -31, -31, -31,
		-31, -31, -31, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -25, -25, -25, -25, -25, -25,
		-25, -25, -25, -25, -25, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -19, -19, -19, -19,
		-19, -19, -19, -19, -19, -19, -19, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -17, -17, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22,
		-27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -32, -32, -32, -32, -32, -32, -32, -32, -32,
		-32, -32, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -30, -30, -30, -30, -30, -30, -30,
		-30, -30, -30, -30, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -24, -24, -24, -24, -24,
		-24, -24, -24, -24, -24, -24, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -18, -18, -18,
		-18, -18, -18, -18, -18, -18, -18, -18, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -12,
		-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13,
		-13, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -23, -23, -23, -23, -23, -23, -23, -23,
		-23, -23, -23, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29,
		-29, -29, -29, -29, -29, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -23, -23, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -17, -17,
		-17, -17, -17, -17, -17, -17, -17, -17, -17, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -8, -8, -8, -8, -8, -8, -8, -8, -8,
		-8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -14, -14, -14, -14, -14, -14, -14,
		-14, -14, -14, -14, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -24, -24, -24, -24, -24,
		-24, -24, -24, -24, -24, -24, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -22, -22, -22,
		-22, -22, -22, -22, -22, -22, -22, -22, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -16,
		-16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13,
		-13, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -7, -7, -7, -7, -7, -7, -7, -7,
		-7, -7, -7, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5,
		-5, -5, -5, -5, -5, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -15, -15, -15, -15,
		-15, -15, -15, -15, -15, -15, -15, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -21, -21,
		-21, -21, -21, -21, -21, -21, -21, -21, -21, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18,
		-15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -12, -12, -12, -12, -12, -12, -12, -12, -12,
		-12, -12, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -6, -6, -6, -6, -6, -6, -6,
		-6, -6, -6, -6, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 3, 3, 3, 3, -1, -1, -1, -1, -1, -4, -4, -4, -4, -4,
		-7, -7, -7, -7, -7, -10, -10, -10, -10, -10, -13, -13, -13, -13, -13, -16, -16, -16, -16, -16,
		-19, -19, -19, -19, -19, -21, -21, -21, -21, -21, -21, -21, -21, -21, -21, -22, -22, -22, -22, -22,
		-22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23,
		-23, -23, -23, -23, -23, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24,
		-25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22,
		-22, -22, -22, -22, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -18,
		-18, -18, -18, -18, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -15, -15, -15, -15, -15, -14,
		-14, -14, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10,
		-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11,
		-11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13,
		-13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -15, -15,
		-15, -15, -15, -14, -14, -14, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -11, -11,
		-11, -11, -11, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -7, -7,
		-7, -7, -7, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -3, -3,
		-3, -3, -3, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0
	};

		int correctionTable2[16384] =
		{
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 4, 4, 4,
			4, 3, 3, 3, 3, 3, 3, 2, 2, 2, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2,
			2, 3, 3, 2, 2, 2, 2, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
			1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4,
			4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
			4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5,
			5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10,
			10, 10, 10, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 16, 16,
			16, 16, 16, 16, 16, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14,
			14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12,
			12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10,
			10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8,
			8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5,
			5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10,
			11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13,
			13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18,
			19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21,
			21, 21, 21, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24,
			24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 22, 22, 22, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 19,
			19, 19, 19, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13,
			13, 13, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10,
			10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3,
			3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7,
			7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11,
			11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15,
			15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18,
			18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
			17, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14,
			14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11,
			11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10,
			10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
			9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3,
			3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7,
			7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11,
			11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15,
			15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18,
			18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
			17, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14,
			14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11,
			11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10,
			10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
			9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3,
			3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7,
			7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11,
			11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15,
			15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18,
			18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
			17, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14,
			14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11,
			11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10,
			10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
			9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 4, 4, 4,
			4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 9, 9,
			9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 14,
			14, 14, 14, 14, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18,
			18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22,
			22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
			21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20,
			20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
			20, 20, 20, 20, 20, 20, 20, 20, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20,
			20, 20, 20, 20, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18,
			18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18, 18, 18, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18,
			18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
			17, 17, 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 13, 13, 13, 13, 13, 10, 10, 10,
			10, 10, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3,
			1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
			10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12,
			12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7,
			5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, -1, -1,
			-1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4,
			4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6,
			6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8,
			9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11,
			11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13,
			13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 11, 11, 11, 11, 11,
			9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 3, 3,
			3, 3, 3, 3, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2,
			-2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0,
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9,
			9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
			11, 11, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 13, 13, 13, 13, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 7, 7,
			7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1,
			1, 1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8,
			8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10,
			10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12,
			13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 11,
			11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5,
			5, 5, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1,
			-2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0,
			0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
			2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9,
			9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11,
			11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9,
			9, 9, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3,
			1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
			10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12,
			12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7,
			5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, -1, -1,
			-1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4,
			4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7,
			7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
			9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12,
			12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 12, 12, 12, 12, 12,
			12, 10, 10, 10, 10, 10, 10, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7,
			5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 0, 0,
			0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
			2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 10, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12,
			12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14,
			14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 14, 14, 14, 12, 12, 12, 12, 12,
			12, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8,
			8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5,
			5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2,
			2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1,
			-1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, 0,
			0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3,
			5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8,
			8, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13,
			13, 13, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17,
			17, 17, 17, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14,
			14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 11, 11,
			11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 8,
			8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6,
			5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3,
			3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
			0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3,
			-3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -3, -3,
			-3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 2,
			2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6,
			7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11,
			11, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12,
			12, 12, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9,
			9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6,
			6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3,
			3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0,
			0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
			1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6,
			6, 6, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11,
			11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16,
			16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 16, 16, 15, 15,
			15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 12,
			12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10,
			9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7,
			7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4,
			4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
			1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2,
			-2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5,
			-5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -4,
			-4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1, -1, -1,
			1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3,
			3, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8,
			8, 8, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12,
			12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9,
			9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6,
			6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3,
			3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1,
			0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2,
			-2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -1, -1, -1, -1, -1,
			-1, -1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4,
			4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9,
			9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 14, 14,
			14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 15,
			15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13,
			12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10,
			10, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7,
			7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4,
			4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1,
			1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2,
			-2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5,
			-5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7,
			-7, -7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4,
			-4, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
			1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6,
			6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11,
			11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 10, 10,
			10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 7,
			7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5,
			4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2,
			2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1,
			-1, -1, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
			-3, -3, -3, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2,
			2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 7, 7,
			7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 12,
			12, 12, 12, 12, 12, 12, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15,
			16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14,
			14, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11,
			11, 11, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8,
			8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5,
			5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2,
			2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, -1,
			-1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3,
			-4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6,
			-6, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5,
			-5, -5, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0,
			0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5,
			5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 10, 10,
			10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 11,
			11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9,
			9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,
			11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
			16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 9, 9, 9, 9, 9, 9, 9, 9, 9, 2, 2, 2, 2, 2, 2,
			2, 2, 2, -5, -5, -5, -5, -5, -5, -5, -5, -5, -8, -8, -8, -8, -8, -8, -8, -8,
			-8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3,
			-3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10,
			10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12,
			12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17,
			17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
			19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21,
			21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23,
			20, 20, 20, 20, 20, 20, 20, 20, 20, 13, 13, 13, 13, 13, 13, 13, 13, 13, 6, 6,
			6, 6, 6, 6, 6, 6, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4, -4, -4, -4,
			-4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2,
			-2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9,
			9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11,
			12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18,
			18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 16, 16, 16, 16, 16, 16, 16, 16,
			16, 9, 9, 9, 9, 9, 9, 9, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7,
			-7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3,
			-3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11,
			11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13,
			13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15,
			15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17,
			17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19,
			20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 20, 20, 20, 20,
			20, 20, 20, 20, 20, 13, 13, 13, 13, 13, 13, 13, 13, 13, 6, 6, 6, 6, 6, 6,
			6, 6, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4, -4, -4, -4, -4, -4, -4, -4,
			-4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12,
			12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14,
			14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16,
			16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19,
			19, 19, 19, 19, 19, 19, 19, 19, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 9, 9,
			9, 9, 9, 9, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7,
			-7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
			4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9,
			9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,
			11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
			16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20,
			20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
			22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 20, 20, 20, 20, 20, 20, 20, 20,
			20, 13, 13, 13, 13, 13, 13, 13, 13, 13, 6, 6, 6, 6, 6, 6, 6, 6, 6, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3,
			-3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10,
			10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12,
			12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17,
			17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
			19, 19, 19, 19, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 9, 9, 9, 9, 9, 9,
			9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6,
			-6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4,
			-4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2,
			-2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9,
			9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11,
			12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18,
			18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20,
			20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23,
			23, 23, 23, 23, 23, 23, 23, 23, 20, 20, 20, 20, 20, 20, 20, 20, 20, 13, 13, 13,
			13, 13, 13, 13, 13, 13, 6, 6, 6, 6, 6, 6, 6, 6, 6, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3,
			-3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11,
			11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
			15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 19, 19, 19, 19, 19, 19, 19, 19, 19,
			19, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 23, 23, 23, 23, 23, 23, 23, 23, 23,
			23, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 27, 27, 27, 27, 27, 27, 27, 27, 27,
			27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 27, 27, 27, 27, 27, 27, 27, 27, 27,
			27, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 15, 15, 15, 15, 15, 15, 15, 15, 15,
			15, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
			12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
			16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
			20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
			12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11,
			11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 19,
			19, 19, 19, 19, 19, 19, 19, 19, 19, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 23,
			23, 23, 23, 23, 23, 23, 23, 23, 23, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 27,
			27, 27, 27, 27, 27, 27, 27, 27, 27, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 19,
			19, 19, 19, 19, 19, 19, 19, 19, 19, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -2, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 22, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 26, 26,
			26, 26, 26, 26, 26, 26, 26, 26, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -2, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 22, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 26, 26,
			26, 26, 26, 26, 26, 26, 26, 26, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14,
			14, 14, 14, 14, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18,
			18, 18, 18, 18, 18, 18, 18, 18, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -2, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2,
			-2, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9,
			9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13,
			13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 17, 17, 17,
			17, 17, 17, 17, 17, 17, 17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20,
			20, 20, 20, 20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 24, 24, 24, 24,
			24, 24, 24, 24, 24, 24, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11,
			11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15,
			15, 15, 15, 15, 15, 13, 13, 13, 13, 13, 13, 13, 13, 13, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -6, -6, -6, -6, -6, -6,
			-6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6, -6, -6,
			-6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2,
			-2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9,
			9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13,
			13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16,
			16, 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 20,
			20, 20, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 12, 12, 12, 12, 12, 12, 12, 12,
			12, 12, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11,
			11, 9, 9, 9, 9, 9, 9, 9, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
			-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
			-8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
			-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
			-2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4,
			4, 4, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 10, 10, 10, 10, 10, 10,
			10, 10, 10, 10, 10, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 16, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 22, 22, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
			28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 27, 27, 27, 27, 27, 27, 27, 27, 27,
			27, 27, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 17, 17, 17, 17, 17, 17, 17,
			17, 17, 17, 17, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11,
			11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 16, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 16, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 22, 22,
			22, 22, 22, 22, 22, 22, 22, 22, 22, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
			28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31,
			31, 31, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 25, 25, 25, 25, 25, 25, 25,
			25, 25, 25, 25, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 15, 15, 15, 15, 15,
			15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 17, 17, 17,
			17, 17, 17, 17, 17, 17, 17, 17, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 23,
			23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
			28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31,
			31, 31, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 37, 37, 37, 37, 37, 37, 37,
			37, 37, 37, 37, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 43, 43, 43, 43, 43,
			43, 43, 43, 43, 43, 43, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 49, 49, 49,
			49, 49, 49, 49, 49, 49, 49, 49, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 55,
			55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
			58, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 52, 52, 52, 52, 52, 52, 52, 52,
			52, 52, 52, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 42, 42, 42, 42, 42, 42,
			42, 42, 42, 42, 42, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 43, 43, 43, 43, 43,
			43, 43, 43, 43, 43, 43, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 49, 49, 49,
			49, 49, 49, 49, 49, 49, 49, 49, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 55,
			55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
			58, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 60, 60, 60, 60, 60, 60, 60, 60,
			60, 60, 60, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 50, 50, 50, 50, 50, 50,
			50, 50, 50, 50, 50, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 44, 44, 44, 44,
			44, 44, 44, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 50, 50,
			50, 50, 50, 50, 50, 50, 50, 50, 50, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
			56, 56, 56, 56, 56, 56, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
			55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 50, 50, 50, 50, 50, 50, 50, 41, 41, 41,
			41, 41, 41, 41, 41, 33, 33, 33, 33, 33, 33, 33, 24, 24, 24, 24, 24, 24, 24, 24,
			20, 20, 20, 20, 20, 20, 20, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
			19, 19, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 17, 17,
			17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 16, 16, 16,
			12, 12, 12, 12, 12, 12, 12, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0,
		};

		int correctionTable3[4096] =
		{
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2,
			-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2,
			-2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 2, 2, 2, 2,
			2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 2, 2, 1,
			1, 1, 1, 1, 0, 0, 0, 0, -1, -1, -1, -1, -2, -2, -2, -2, -2, -3, -3, -3,
			-3, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -4, -4, -4, -4,
			-4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
			-2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4,
			-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -4, -4, -4, -4,
			-4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
			-2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4,
			-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -4, -4, -4, -4,
			-4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
			-2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4,
			-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -4, -4, -4, -4,
			-4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2,
			-2, -2, -2, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6,
			-6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3,
			-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5,
			-5, -5, -5, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
			-3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3,
			-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -6,
			-6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4,
			-4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
			-3, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3,
			-3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6,
			-6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3,
			-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5,
			-5, -5, -5, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
			-3, -3, -3, -3, -3, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3,
			-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4,
			-4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
			-6, -6, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2,
			-2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5,
			-5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -7, -7,
			-7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -3,
			-3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5,
			-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4,
			-4, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3,
			-3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6,
			-6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -5, -5, -5,
			-5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -4, -4,
			-4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3,
			-2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4,
			-4, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7,
			-7, -7, -7, -7, -7, -7, -7, -7, -7, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4,
			-4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5,
			-5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -4, -4,
			-4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -3,
			-3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5,
			-6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,
			-7, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3,
			-3, -3, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -7,
			-7, -7, -7, -7, -7, -7, -7, -7, -10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9,
			-9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7,
			-7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3,
			-6, -6, -6, -6, -6, -6, -6, -6, -6, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8,
			-8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4,
			-4, -4, -4, -7, -7, -7, -7, -7, -7, -7, -7, -7, -10, -10, -10, -10, -10, -10, -10, -10,
			-10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7,
			-7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3,
			-3, -3, -3, -3, -6, -6, -6, -6, -6, -6, -6, -6, -6, -9, -9, -9, -9, -9, -9, -9,
			-9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7,
			-6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4,
			-4, -4, -4, -4, -4, -4, -4, -7, -7, -7, -7, -7, -7, -7, -7, -7, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8,
			-8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6,
			-6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -3,
			-3, -3, -3, -3, -3, -3, -3, -3, -6, -6, -6, -6, -6, -6, -6, -6, -6, -9, -9, -9,
			-9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7,
			-7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5,
			-5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -7, -7, -7, -7, -7, -7, -7, -7, -7,
			-10, -10, -10, -10, -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8,
			-8, -8, -8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4,
			-4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -6, -6, -6, -6, -6, -6, -6, -6,
			-6, -9, -9, -9, -9, -9, -9, -9, -9, -9, -8, -8, -8, -8, -8, -8, -8, -8, -8, -7,
			-7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -9, -9, -9,
			-9, -9, -9, -9, -9, -9, -9, -7, -7, -7, -7, -7, -7, -7, -7, -7, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -10, -10, -10, -10,
			-10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -8, -8,
			-8, -8, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9,
			-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -7, -7, -7, -7, -7, -7, -7, -7, -7,
			-7, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9,
			-9, -9, -9, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8,
			-8, -8, -8, -8, -8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -6, -6, -6, -6,
			-6, -6, -6, -6, -6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8,
			-8, -8, -8, -8, -8, -8, -8, -8, -8, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
			-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -11, -11, -11, -11, -11, -11, -11, -11, -11,
			-11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -9, -9, -9, -9, -9, -9, -9,
			-9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11,
			-11, -11, -11, -11, -11, -11, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9,
			-9, -9, -9, -9, -9, -9, -9, -9, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -7,
			-7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
			-8, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -6, -6, -6, -6, -6, -6, -6, -6,
			-6, -6, -6, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -8, -8, -8, -8, -8, -8,
			-8, -8, -8, -8, -8, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -2, -2, -2, -2,
			-6, -6, -6, -6, -6, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -9, -9, -9, -9, -9,
			-8, -8, -8, -8, -8, -7, -7, -7, -7, -7, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5,
			-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5,
			-4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -2, -2, -1, -1, 0, 0
		};

	uint16 lut1[3073] = {
		0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
		20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
		40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
		60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
		80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
		100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
		120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
		140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
		160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
		180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
		200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
		220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
		240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259,
		260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279,
		280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
		300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319,
		320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339,
		340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
		360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379,
		380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399,
		400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
		420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439,
		440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 451, 453, 455, 457, 459, 461, 463, 465, 467, 469,
		471, 473, 475, 477, 479, 480, 482, 484, 486, 488, 490, 492, 494, 496, 498, 500, 502, 504, 506, 508,
		510, 511, 513, 515, 517, 519, 521, 523, 525, 527, 529, 531, 533, 535, 537, 539, 541, 542, 544, 546,
		548, 550, 552, 554, 556, 558, 560, 562, 564, 566, 568, 570, 572, 574, 576, 578, 580, 582, 584, 586,
		588, 590, 592, 594, 596, 598, 600, 602, 604, 606, 608, 610, 612, 614, 616, 618, 620, 622, 624, 626,
		628, 630, 632, 634, 636, 638, 640, 642, 644, 646, 648, 650, 652, 654, 656, 658, 660, 662, 664, 666,
		668, 670, 672, 674, 676, 678, 680, 682, 684, 686, 688, 690, 692, 694, 696, 698, 700, 702, 704, 706,
		708, 710, 712, 714, 716, 718, 720, 722, 724, 726, 728, 730, 732, 734, 736, 738, 740, 742, 744, 746,
		748, 750, 752, 754, 756, 758, 760, 762, 764, 766, 768, 770, 772, 774, 776, 778, 780, 782, 784, 786,
		788, 790, 792, 794, 796, 798, 800, 802, 804, 806, 808, 810, 812, 814, 816, 818, 820, 822, 824, 826,
		828, 830, 832, 834, 836, 838, 840, 842, 844, 846, 848, 850, 852, 854, 856, 858, 860, 862, 864, 866,
		868, 870, 872, 874, 876, 878, 880, 882, 884, 886, 888, 890, 892, 894, 896, 898, 900, 902, 904, 906,
		908, 910, 912, 914, 916, 918, 920, 922, 924, 926, 928, 930, 932, 934, 936, 938, 940, 942, 944, 946,
		948, 950, 952, 954, 956, 958, 960, 962, 964, 966, 968, 970, 973, 975, 977, 979, 981, 983, 985, 987,
		990, 992, 994, 996, 998, 1000, 1002, 1004, 1007, 1009, 1011, 1013, 1015, 1017, 1019, 1021, 1024, 1026, 1028, 1030,
		1032, 1034, 1036, 1038, 1041, 1043, 1045, 1047, 1049, 1051, 1053, 1055, 1058, 1060, 1062, 1064, 1066, 1068, 1070, 1072,
		1075, 1077, 1079, 1081, 1083, 1085, 1087, 1089, 1092, 1095, 1098, 1101, 1104, 1107, 1110, 1113, 1116, 1119, 1122, 1125,
		1128, 1131, 1134, 1137, 1140, 1143, 1146, 1149, 1152, 1155, 1158, 1161, 1164, 1167, 1170, 1173, 1176, 1179, 1182, 1185,
		1188, 1191, 1194, 1197, 1200, 1203, 1206, 1209, 1212, 1215, 1218, 1221, 1224, 1227, 1230, 1233, 1236, 1239, 1242, 1245,
		1248, 1251, 1254, 1257, 1260, 1263, 1266, 1269, 1272, 1275, 1278, 1281, 1284, 1287, 1290, 1293, 1296, 1299, 1302, 1305,
		1308, 1311, 1314, 1317, 1320, 1323, 1326, 1329, 1332, 1335, 1338, 1341, 1344, 1347, 1350, 1353, 1356, 1359, 1362, 1365,
		1368, 1371, 1374, 1377, 1380, 1383, 1386, 1389, 1392, 1395, 1398, 1401, 1404, 1407, 1410, 1413, 1416, 1419, 1422, 1425,
		1428, 1431, 1434, 1437, 1440, 1443, 1446, 1449, 1452, 1455, 1458, 1461, 1464, 1467, 1470, 1473, 1476, 1479, 1482, 1485,
		1488, 1491, 1494, 1497, 1500, 1503, 1506, 1509, 1512, 1515, 1518, 1521, 1524, 1527, 1530, 1533, 1536, 1539, 1542, 1545,
		1548, 1551, 1554, 1557, 1560, 1563, 1566, 1569, 1572, 1575, 1578, 1581, 1584, 1587, 1590, 1593, 1596, 1599, 1602, 1605,
		1608, 1611, 1614, 1617, 1620, 1623, 1626, 1629, 1632, 1635, 1638, 1641, 1644, 1647, 1650, 1653, 1656, 1659, 1662, 1665,
		1668, 1671, 1674, 1677, 1680, 1683, 1686, 1689, 1692, 1695, 1698, 1701, 1704, 1707, 1710, 1713, 1716, 1719, 1722, 1725,
		1728, 1731, 1734, 1737, 1740, 1743, 1746, 1749, 1752, 1755, 1758, 1761, 1764, 1767, 1770, 1773, 1776, 1779, 1782, 1785,
		1788, 1791, 1794, 1797, 1800, 1803, 1806, 1809, 1812, 1815, 1818, 1821, 1824, 1827, 1830, 1833, 1836, 1839, 1842, 1845,
		1848, 1851, 1854, 1857, 1860, 1863, 1867, 1871, 1874, 1878, 1882, 1885, 1889, 1893, 1896, 1900, 1904, 1907, 1911, 1915,
		1919, 1922, 1926, 1930, 1933, 1937, 1941, 1944, 1948, 1952, 1955, 1959, 1963, 1966, 1970, 1974, 1978, 1981, 1985, 1989,
		1992, 1996, 2000, 2003, 2007, 2011, 2014, 2018, 2022, 2025, 2029, 2033, 2037, 2040, 2044, 2048, 2051, 2055, 2059, 2062,
		2066, 2070, 2073, 2077, 2081, 2084, 2088, 2092, 2096, 2100, 2104, 2108, 2112, 2116, 2120, 2124, 2128, 2132, 2136, 2140,
		2144, 2148, 2152, 2156, 2160, 2164, 2168, 2172, 2176, 2180, 2184, 2188, 2192, 2196, 2200, 2204, 2208, 2212, 2216, 2220,
		2224, 2228, 2232, 2236, 2240, 2244, 2248, 2252, 2256, 2260, 2264, 2268, 2272, 2276, 2280, 2284, 2288, 2292, 2296, 2300,
		2304, 2308, 2312, 2316, 2320, 2324, 2328, 2332, 2336, 2340, 2344, 2348, 2352, 2356, 2360, 2364, 2368, 2372, 2376, 2380,
		2384, 2388, 2392, 2396, 2400, 2404, 2408, 2412, 2416, 2420, 2424, 2428, 2432, 2436, 2440, 2444, 2448, 2452, 2456, 2460,
		2464, 2468, 2472, 2476, 2480, 2484, 2488, 2492, 2496, 2500, 2504, 2508, 2512, 2516, 2520, 2524, 2528, 2532, 2536, 2540,
		2544, 2548, 2552, 2556, 2560, 2564, 2568, 2572, 2576, 2580, 2584, 2588, 2592, 2596, 2600, 2604, 2608, 2612, 2616, 2620,
		2624, 2628, 2632, 2636, 2640, 2644, 2648, 2652, 2656, 2660, 2664, 2668, 2672, 2676, 2680, 2684, 2688, 2692, 2696, 2700,
		2704, 2708, 2712, 2716, 2720, 2724, 2728, 2732, 2736, 2740, 2744, 2748, 2752, 2756, 2760, 2764, 2768, 2772, 2776, 2780,
		2784, 2788, 2792, 2796, 2800, 2804, 2808, 2812, 2816, 2820, 2824, 2828, 2832, 2836, 2840, 2844, 2848, 2852, 2856, 2860,
		2864, 2868, 2872, 2877, 2881, 2885, 2890, 2894, 2899, 2903, 2907, 2912, 2916, 2920, 2925, 2929, 2934, 2938, 2942, 2947,
		2951, 2955, 2960, 2964, 2969, 2973, 2977, 2982, 2986, 2990, 2995, 2999, 3004, 3008, 3012, 3017, 3021, 3025, 3030, 3034,
		3039, 3043, 3047, 3052, 3056, 3060, 3065, 3069, 3074, 3078, 3082, 3087, 3091, 3095, 3100, 3104, 3109, 3113, 3117, 3122,
		3126, 3130, 3135, 3139, 3144, 3149, 3154, 3159, 3164, 3169, 3174, 3179, 3184, 3189, 3194, 3199, 3204, 3209, 3214, 3219,
		3224, 3229, 3234, 3239, 3244, 3249, 3254, 3259, 3264, 3269, 3274, 3279, 3284, 3289, 3294, 3299, 3304, 3309, 3314, 3319,
		3324, 3329, 3334, 3339, 3344, 3349, 3354, 3359, 3364, 3369, 3374, 3379, 3384, 3389, 3394, 3399, 3404, 3409, 3414, 3419,
		3424, 3429, 3434, 3439, 3444, 3449, 3454, 3459, 3464, 3469, 3474, 3479, 3484, 3489, 3494, 3499, 3504, 3509, 3514, 3519,
		3524, 3529, 3534, 3539, 3544, 3549, 3554, 3559, 3564, 3569, 3574, 3579, 3584, 3589, 3594, 3599, 3604, 3609, 3614, 3619,
		3624, 3629, 3634, 3639, 3644, 3649, 3654, 3659, 3664, 3669, 3674, 3679, 3684, 3689, 3694, 3699, 3704, 3709, 3714, 3719,
		3724, 3729, 3734, 3739, 3744, 3749, 3754, 3759, 3764, 3769, 3774, 3779, 3784, 3789, 3794, 3799, 3804, 3809, 3814, 3819,
		3824, 3829, 3834, 3839, 3844, 3849, 3854, 3859, 3864, 3869, 3874, 3879, 3884, 3889, 3894, 3899, 3904, 3909, 3914, 3919,
		3924, 3929, 3934, 3939, 3944, 3949, 3954, 3959, 3964, 3969, 3974, 3979, 3984, 3989, 3994, 3999, 4004, 4009, 4014, 4019,
		4024, 4029, 4034, 4039, 4044, 4049, 4054, 4059, 4064, 4069, 4074, 4079, 4084, 4089, 4094, 4099, 4104, 4109, 4114, 4119,
		4124, 4129, 4135, 4140, 4145, 4150, 4155, 4161, 4166, 4171, 4176, 4181, 4187, 4192, 4197, 4202, 4207, 4212, 4218, 4223,
		4228, 4233, 4238, 4244, 4249, 4254, 4259, 4264, 4270, 4275, 4280, 4285, 4290, 4295, 4301, 4306, 4311, 4316, 4321, 4327,
		4332, 4337, 4342, 4347, 4353, 4358, 4363, 4368, 4373, 4378, 4384, 4389, 4394, 4399, 4404, 4410, 4415, 4420, 4425, 4430,
		4436, 4442, 4448, 4454, 4460, 4466, 4472, 4478, 4484, 4490, 4496, 4502, 4508, 4514, 4520, 4526, 4532, 4538, 4544, 4550,
		4556, 4562, 4568, 4574, 4580, 4586, 4592, 4598, 4604, 4610, 4616, 4622, 4628, 4634, 4640, 4646, 4652, 4658, 4664, 4670,
		4676, 4682, 4688, 4694, 4700, 4706, 4712, 4718, 4724, 4730, 4736, 4742, 4748, 4754, 4760, 4766, 4772, 4778, 4784, 4790,
		4796, 4802, 4808, 4814, 4820, 4826, 4832, 4838, 4844, 4850, 4856, 4862, 4868, 4874, 4880, 4886, 4892, 4898, 4904, 4910,
		4916, 4922, 4928, 4934, 4940, 4946, 4952, 4958, 4964, 4970, 4976, 4982, 4988, 4994, 5000, 5006, 5012, 5018, 5024, 5030,
		5036, 5042, 5048, 5054, 5060, 5066, 5072, 5078, 5084, 5090, 5096, 5102, 5108, 5114, 5120, 5126, 5132, 5138, 5144, 5150,
		5156, 5162, 5168, 5174, 5180, 5186, 5192, 5198, 5204, 5210, 5216, 5222, 5228, 5234, 5240, 5246, 5252, 5258, 5264, 5270,
		5276, 5282, 5288, 5294, 5300, 5306, 5312, 5318, 5324, 5330, 5336, 5342, 5348, 5354, 5360, 5366, 5372, 5378, 5384, 5390,
		5396, 5402, 5408, 5414, 5420, 5426, 5432, 5438, 5444, 5450, 5456, 5462, 5468, 5474, 5480, 5486, 5492, 5498, 5504, 5510,
		5516, 5522, 5528, 5534, 5540, 5546, 5552, 5558, 5564, 5570, 5576, 5582, 5589, 5595, 5601, 5607, 5613, 5619, 5625, 5631,
		5637, 5643, 5649, 5655, 5661, 5667, 5673, 5679, 5686, 5692, 5698, 5704, 5710, 5716, 5722, 5728, 5734, 5740, 5746, 5752,
		5758, 5764, 5770, 5776, 5783, 5789, 5795, 5801, 5807, 5813, 5819, 5825, 5831, 5837, 5843, 5849, 5855, 5861, 5867, 5873,
		5880, 5886, 5892, 5898, 5904, 5910, 5916, 5922, 5928, 5934, 5940, 5946, 5952, 5958, 5964, 5970, 5977, 5984, 5991, 5998,
		6005, 6012, 6019, 6026, 6033, 6040, 6047, 6054, 6061, 6068, 6075, 6082, 6089, 6096, 6103, 6110, 6117, 6124, 6131, 6138,
		6145, 6152, 6159, 6166, 6173, 6180, 6187, 6194, 6201, 6208, 6215, 6222, 6229, 6236, 6243, 6250, 6257, 6264, 6271, 6278,
		6285, 6292, 6299, 6306, 6313, 6320, 6327, 6334, 6341, 6348, 6355, 6362, 6369, 6376, 6383, 6390, 6397, 6404, 6411, 6418,
		6425, 6432, 6439, 6446, 6453, 6460, 6467, 6474, 6481, 6488, 6495, 6502, 6509, 6516, 6523, 6530, 6537, 6544, 6551, 6558,
		6565, 6572, 6579, 6586, 6593, 6600, 6607, 6614, 6621, 6628, 6635, 6642, 6649, 6656, 6663, 6670, 6677, 6684, 6691, 6698,
		6705, 6712, 6719, 6726, 6733, 6740, 6747, 6754, 6761, 6768, 6775, 6782, 6789, 6796, 6803, 6810, 6817, 6824, 6831, 6838,
		6845, 6852, 6859, 6866, 6873, 6880, 6887, 6894, 6901, 6908, 6915, 6922, 6929, 6936, 6943, 6950, 6957, 6964, 6971, 6978,
		6985, 6992, 6999, 7006, 7013, 7020, 7027, 7034, 7041, 7048, 7055, 7062, 7069, 7076, 7083, 7090, 7097, 7104, 7111, 7118,
		7125, 7132, 7139, 7146, 7153, 7160, 7167, 7174, 7181, 7188, 7195, 7202, 7209, 7216, 7223, 7230, 7237, 7244, 7251, 7258,
		7265, 7272, 7279, 7286, 7293, 7300, 7307, 7314, 7321, 7328, 7335, 7342, 7349, 7356, 7363, 7370, 7377, 7384, 7391, 7398,
		7405, 7412, 7419, 7426, 7433, 7440, 7447, 7454, 7461, 7468, 7475, 7482, 7489, 7496, 7503, 7510, 7517, 7524, 7531, 7538,
		7545, 7552, 7559, 7566, 7573, 7580, 7587, 7594, 7601, 7608, 7615, 7622, 7629, 7636, 7643, 7650, 7657, 7664, 7671, 7678,
		7685, 7692, 7699, 7706, 7713, 7720, 7727, 7734, 7741, 7748, 7755, 7762, 7769, 7776, 7784, 7792, 7800, 7808, 7816, 7824,
		7832, 7840, 7848, 7856, 7864, 7872, 7880, 7888, 7896, 7903, 7911, 7919, 7927, 7935, 7943, 7951, 7959, 7967, 7975, 7983,
		7991, 7999, 8007, 8015, 8023, 8030, 8038, 8046, 8054, 8062, 8070, 8078, 8086, 8094, 8102, 8110, 8118, 8126, 8134, 8142,
		8150, 8157, 8165, 8173, 8181, 8189, 8197, 8205, 8213, 8221, 8229, 8237, 8245, 8253, 8261, 8269, 8277, 8285, 8293, 8301,
		8309, 8317, 8325, 8333, 8341, 8349, 8357, 8365, 8373, 8381, 8389, 8397, 8405, 8413, 8421, 8429, 8437, 8445, 8453, 8461,
		8469, 8477, 8485, 8493, 8501, 8509, 8517, 8525, 8533, 8541, 8549, 8557, 8565, 8573, 8581, 8589, 8597, 8605, 8613, 8621,
		8629, 8637, 8645, 8653, 8661, 8669, 8677, 8685, 8693, 8701, 8709, 8717, 8725, 8733, 8741, 8749, 8757, 8765, 8773, 8781,
		8789, 8797, 8805, 8813, 8821, 8829, 8837, 8845, 8853, 8861, 8869, 8877, 8885, 8893, 8901, 8909, 8917, 8925, 8933, 8941,
		8949, 8957, 8965, 8973, 8981, 8989, 8997, 9005, 9013, 9021, 9029, 9037, 9045, 9053, 9061, 9069, 9077, 9085, 9093, 9101,
		9109, 9117, 9125, 9133, 9141, 9149, 9157, 9165, 9173, 9181, 9189, 9197, 9205, 9213, 9221, 9229, 9237, 9245, 9253, 9261,
		9269, 9277, 9285, 9293, 9301, 9309, 9317, 9325, 9333, 9341, 9349, 9357, 9365, 9373, 9381, 9389, 9397, 9405, 9413, 9421,
		9429, 9437, 9445, 9453, 9461, 9469, 9477, 9485, 9493, 9501, 9509, 9517, 9525, 9533, 9541, 9549, 9557, 9565, 9573, 9581,
		9589, 9597, 9605, 9613, 9621, 9629, 9637, 9645, 9653, 9661, 9669, 9677, 9685, 9693, 9701, 9709, 9717, 9725, 9733, 9741,
		9749, 9757, 9765, 9773, 9781, 9789, 9797, 9805, 9813, 9821, 9830, 9839, 9848, 9857, 9866, 9875, 9884, 9893, 9902, 9911,
		9920, 9929, 9938, 9947, 9956, 9964, 9973, 9982, 9991, 10000, 10009, 10018, 10027, 10036, 10045, 10054, 10063, 10072, 10081, 10090,
		10099, 10107, 10116, 10125, 10134, 10143, 10152, 10161, 10170, 10179, 10188, 10197, 10206, 10215, 10224, 10233, 10242, 10250, 10259, 10268,
		10277, 10286, 10295, 10304, 10313, 10322, 10331, 10340, 10349, 10358, 10367, 10376, 10385, 10394, 10403, 10412, 10421, 10430, 10439, 10448,
		10457, 10466, 10475, 10484, 10493, 10502, 10511, 10520, 10529, 10538, 10547, 10556, 10565, 10574, 10583, 10592, 10601, 10610, 10619, 10628,
		10637, 10646, 10655, 10664, 10673, 10682, 10691, 10700, 10709, 10718, 10727, 10736, 10745, 10754, 10763, 10772, 10781, 10790, 10799, 10808,
		10817, 10826, 10835, 10844, 10853, 10862, 10871, 10880, 10889, 10898, 10907, 10916, 10925, 10934, 10943, 10952, 10962, 10971, 10980, 10989,
		10998, 11007, 11016, 11025, 11034, 11043, 11052, 11061, 11070, 11079, 11088, 11097, 11106, 11115, 11124, 11133, 11142, 11151, 11160, 11169,
		11178, 11187, 11196, 11205, 11214, 11223, 11232, 11241, 11250, 11259, 11268, 11277, 11286, 11295, 11304, 11313, 11322, 11331, 11340, 11349,
		11358, 11367, 11376, 11385, 11394, 11403, 11412, 11421, 11430, 11439, 11448, 11457, 11466, 11475, 11484, 11493, 11502, 11511, 11520, 11529,
		11538, 11547, 11556, 11565, 11574, 11583, 11592, 11601, 11610, 11619, 11628, 11637, 11646, 11655, 11664, 11673, 11682, 11691, 11700, 11709,
		11718, 11727, 11736, 11745, 11754, 11763, 11772, 11781, 11790, 11799, 11808, 11817, 11826, 11835, 11844, 11853, 11862, 11871, 11880, 11889,
		11898, 11907, 11916, 11925, 11934, 11943, 11952, 11961, 11970, 11979, 11988, 11997, 12006, 12015, 12024, 12033, 12042, 12051, 12060, 12069,
		12078, 12087, 12096, 12105, 12114, 12123, 12133, 12143, 12153, 12163, 12173, 12183, 12193, 12202, 12212, 12222, 12232, 12242, 12252, 12262,
		12272, 12281, 12291, 12301, 12311, 12321, 12331, 12341, 12351, 12360, 12370, 12380, 12390, 12400, 12410, 12420, 12430, 12439, 12449, 12459,
		12469, 12479, 12489, 12499, 12509, 12518, 12528, 12538, 12548, 12558, 12568, 12578, 12588, 12597, 12607, 12617, 12627, 12637, 12647, 12657,
		12667, 12676, 12686, 12696, 12706, 12716, 12726, 12736, 12746, 12756, 12766, 12776, 12786, 12796, 12806, 12816, 12826, 12836, 12846, 12856,
		12866, 12876, 12886, 12896, 12906, 12916, 12926, 12936, 12946, 12956, 12966, 12976, 12986, 12996, 13006, 13016, 13026, 13036, 13046, 13056,
		13066, 13076, 13086, 13096, 13106, 13116, 13126, 13136, 13146, 13156, 13166, 13176, 13186, 13196, 13206, 13216, 13226, 13236, 13246, 13256,
		13266, 13276, 13286, 13296, 13306, 13316, 13326, 13336, 13346, 13356, 13366, 13376, 13386, 13396, 13406, 13416, 13426, 13436, 13446, 13456,
		13466, 13476, 13486, 13496, 13506, 13516, 13526, 13536, 13546, 13556, 13566, 13576, 13586, 13596, 13606, 13616, 13626, 13636, 13646, 13656,
		13666, 13676, 13686, 13696, 13706, 13716, 13726, 13736, 13746, 13756, 13766, 13776, 13786, 13796, 13806, 13816, 13826, 13836, 13846, 13856,
		13866, 13876, 13886, 13896, 13906, 13916, 13926, 13936, 13946, 13956, 13966, 13976, 13986, 13996, 14006, 14016, 14026, 14036, 14046, 14056,
		14066, 14076, 14086, 14096, 14106, 14116, 14126, 14136, 14146, 14156, 14166, 14176, 14186, 14196, 14206, 14216, 14226, 14236, 14246, 14256,
		14266, 14276, 14286, 14296, 14306, 14316, 14326, 14336, 14346, 14356, 14366, 14376, 14386, 14396, 14406, 14416, 14426, 14436, 14446, 14456,
		14466, 14476, 14486, 14496, 14506, 14516, 14526, 14536, 14546, 14556, 14566, 14576, 14586, 14596, 14606, 14616, 14626, 14636, 14646, 14656,
		14666, 14676, 14687, 14698, 14709, 14720, 14731, 14742, 14753, 14763, 14774, 14785, 14796, 14807, 14818, 14829, 14840, 14850, 14861, 14872,
		14883, 14894, 14905, 14916, 14927, 14937, 14948, 14959, 14970, 14981, 14992, 15003, 15014, 15024, 15035, 15046, 15057, 15068, 15079, 15090,
		15101, 15111, 15122, 15133, 15144, 15155, 15166, 15177, 15188, 15198, 15209, 15220, 15231, 15242, 15253, 15264, 15275, 15285, 15296, 15307,
		15318, 15329, 15340, 15351, 15362, 15373, 15384, 15395, 15406, 15417, 15428, 15439, 15450, 15461, 15472, 15483, 15494, 15505, 15516, 15527,
		15538, 15549, 15560, 15571, 15582, 15593, 15604, 15615, 15626, 15637, 15648, 15659, 15670, 15681, 15692, 15703, 15714, 15725, 15736, 15747,
		15758, 15769, 15780, 15791, 15802, 15813, 15824, 15835, 15846, 15857, 15868, 15879, 15890, 15901, 15912, 15923, 15934, 15945, 15956, 15967,
		15978, 15989, 16000, 16011, 16022, 16033, 16044, 16055, 16066, 16070, 16075, 16080, 16085, 16090, 16095, 16100, 16105, 16110, 16115, 16120,
		16125, 16130, 16135, 16140, 16145, 16150, 16155, 16160, 16165, 16170, 16174, 16179, 16184, 16189, 16194, 16199, 16204, 16209, 16214, 16219,
		16224, 16229, 16234, 16239, 16244, 16249, 16254, 16259, 16264, 16269, 16274, 16278, 16283, 16288, 16293, 16298, 16303, 16308, 16313, 16318,
		16323, 16328, 16333, 16338, 16343, 16348, 16353, 16358, 16363, 16368, 16373, 16378, 16383
	};


	uint16 lut2[4098] = {
		0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
		20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
		40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
		60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
		80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
		100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
		120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
		140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
		160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
		180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
		200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
		220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
		240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259,
		260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279,
		280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
		300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319,
		320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339,
		340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
		360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379,
		380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399,
		400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
		420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439,
		440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459,
		460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
		480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499,
		500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519,
		520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539,
		540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559,
		560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579,
		580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599,
		600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619,
		620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639,
		640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659,
		660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679,
		680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699,
		700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719,
		720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739,
		740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759,
		760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779,
		780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799,
		800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819,
		820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839,
		840, 841, 842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859,
		860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879,
		880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899,
		900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919,
		920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 939,
		940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959,
		960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979,
		980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 999,
		1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019,
		1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039,
		1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059,
		1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079,
		1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099,
		1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119,
		1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139,
		1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159,
		1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179,
		1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199,
		1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219,
		1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239,
		1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259,
		1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279,
		1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 1299,
		1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319,
		1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339,
		1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359,
		1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379,
		1380, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399,
		1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419,
		1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439,
		1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459,
		1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479,
		1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499,
		1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 1519,
		1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536, 1537, 1538, 1539,
		1540, 1541, 1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560,
		1561, 1562, 1563, 1564, 1565, 1566, 1567, 1568, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581,
		1582, 1583, 1584, 1585, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596, 1597, 1598, 1599, 1600, 1601, 1602,
		1604, 1605, 1607, 1609, 1611, 1613, 1615, 1617, 1619, 1621, 1623, 1625, 1627, 1629, 1631, 1633, 1635, 1636, 1638, 1640,
		1642, 1644, 1646, 1648, 1650, 1652, 1654, 1656, 1658, 1660, 1662, 1664, 1666, 1667, 1669, 1671, 1673, 1675, 1677, 1679,
		1681, 1683, 1685, 1687, 1689, 1691, 1693, 1695, 1697, 1698, 1700, 1702, 1704, 1706, 1708, 1710, 1712, 1714, 1716, 1718,
		1720, 1722, 1724, 1726, 1728, 1730, 1732, 1734, 1736, 1738, 1740, 1742, 1744, 1746, 1748, 1750, 1752, 1754, 1756, 1758,
		1760, 1762, 1764, 1766, 1768, 1770, 1772, 1774, 1776, 1778, 1780, 1782, 1784, 1786, 1788, 1790, 1792, 1794, 1796, 1798,
		1800, 1802, 1804, 1806, 1808, 1810, 1812, 1814, 1816, 1818, 1820, 1822, 1824, 1826, 1828, 1830, 1832, 1834, 1836, 1838,
		1840, 1842, 1844, 1846, 1848, 1850, 1852, 1854, 1856, 1858, 1860, 1862, 1864, 1866, 1868, 1870, 1872, 1874, 1876, 1878,
		1880, 1882, 1884, 1886, 1888, 1890, 1892, 1894, 1896, 1898, 1900, 1902, 1904, 1906, 1908, 1910, 1912, 1914, 1916, 1918,
		1920, 1922, 1924, 1926, 1928, 1930, 1932, 1934, 1936, 1938, 1940, 1942, 1944, 1946, 1948, 1950, 1952, 1954, 1956, 1958,
		1960, 1962, 1964, 1966, 1968, 1970, 1972, 1974, 1976, 1978, 1980, 1982, 1984, 1986, 1988, 1990, 1992, 1994, 1996, 1998,
		2000, 2002, 2004, 2006, 2008, 2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024, 2026, 2028, 2030, 2032, 2034, 2036, 2038,
		2040, 2042, 2044, 2046, 2048, 2050, 2052, 2054, 2056, 2058, 2060, 2062, 2064, 2066, 2068, 2070, 2072, 2074, 2076, 2078,
		2080, 2082, 2084, 2086, 2088, 2090, 2092, 2094, 2096, 2098, 2100, 2102, 2104, 2106, 2108, 2110, 2112, 2114, 2116, 2118,
		2120, 2122, 2125, 2127, 2129, 2131, 2133, 2136, 2138, 2140, 2142, 2144, 2147, 2149, 2151, 2153, 2155, 2157, 2160, 2162,
		2164, 2166, 2168, 2171, 2173, 2175, 2177, 2179, 2182, 2184, 2186, 2188, 2190, 2192, 2195, 2197, 2199, 2201, 2203, 2206,
		2208, 2210, 2212, 2214, 2217, 2219, 2221, 2223, 2225, 2227, 2230, 2232, 2234, 2236, 2238, 2241, 2243, 2245, 2247, 2249,
		2252, 2255, 2258, 2261, 2264, 2267, 2270, 2273, 2276, 2279, 2282, 2285, 2288, 2291, 2294, 2297, 2300, 2303, 2306, 2309,
		2312, 2315, 2318, 2321, 2324, 2327, 2330, 2333, 2336, 2339, 2342, 2345, 2348, 2351, 2354, 2357, 2360, 2363, 2366, 2369,
		2372, 2375, 2378, 2381, 2384, 2387, 2390, 2393, 2396, 2399, 2402, 2405, 2408, 2411, 2414, 2417, 2420, 2423, 2426, 2429,
		2432, 2435, 2438, 2441, 2444, 2447, 2450, 2453, 2456, 2459, 2462, 2465, 2468, 2471, 2474, 2477, 2480, 2483, 2486, 2489,
		2492, 2495, 2498, 2501, 2504, 2507, 2510, 2513, 2516, 2519, 2522, 2525, 2528, 2531, 2534, 2537, 2540, 2543, 2546, 2549,
		2552, 2555, 2558, 2561, 2564, 2567, 2570, 2573, 2576, 2579, 2582, 2585, 2588, 2591, 2594, 2597, 2600, 2603, 2606, 2609,
		2612, 2615, 2618, 2621, 2624, 2627, 2630, 2633, 2636, 2639, 2642, 2645, 2648, 2651, 2654, 2657, 2660, 2663, 2666, 2669,
		2672, 2675, 2678, 2681, 2684, 2687, 2690, 2693, 2696, 2699, 2702, 2705, 2708, 2711, 2714, 2717, 2720, 2723, 2726, 2729,
		2732, 2735, 2738, 2741, 2744, 2747, 2750, 2753, 2756, 2759, 2762, 2765, 2768, 2771, 2774, 2777, 2780, 2783, 2786, 2789,
		2792, 2795, 2798, 2801, 2804, 2807, 2810, 2813, 2816, 2819, 2822, 2825, 2828, 2831, 2834, 2837, 2840, 2843, 2846, 2849,
		2852, 2855, 2858, 2861, 2864, 2867, 2870, 2873, 2876, 2879, 2882, 2885, 2888, 2891, 2894, 2897, 2900, 2903, 2906, 2909,
		2912, 2915, 2918, 2921, 2924, 2927, 2930, 2933, 2936, 2939, 2942, 2945, 2948, 2951, 2954, 2957, 2960, 2963, 2966, 2969,
		2972, 2975, 2978, 2981, 2984, 2987, 2990, 2993, 2996, 2999, 3002, 3005, 3008, 3011, 3014, 3017, 3020, 3023, 3027, 3030,
		3034, 3038, 3041, 3045, 3049, 3052, 3056, 3059, 3063, 3067, 3070, 3074, 3078, 3081, 3085, 3088, 3092, 3096, 3099, 3103,
		3107, 3110, 3114, 3117, 3121, 3125, 3128, 3132, 3136, 3139, 3143, 3146, 3150, 3154, 3157, 3161, 3165, 3168, 3172, 3175,
		3179, 3183, 3186, 3190, 3194, 3197, 3201, 3204, 3208, 3212, 3215, 3219, 3223, 3226, 3230, 3233, 3237, 3241, 3244, 3248,
		3252, 3256, 3260, 3264, 3268, 3272, 3276, 3280, 3284, 3288, 3292, 3296, 3300, 3304, 3308, 3312, 3316, 3320, 3324, 3328,
		3332, 3336, 3340, 3344, 3348, 3352, 3356, 3360, 3364, 3368, 3372, 3376, 3380, 3384, 3388, 3392, 3396, 3400, 3404, 3408,
		3412, 3416, 3420, 3424, 3428, 3432, 3436, 3440, 3444, 3448, 3452, 3456, 3460, 3464, 3468, 3472, 3476, 3480, 3484, 3488,
		3492, 3496, 3500, 3504, 3508, 3512, 3516, 3520, 3524, 3528, 3532, 3536, 3540, 3544, 3548, 3552, 3556, 3560, 3564, 3568,
		3572, 3576, 3580, 3584, 3588, 3592, 3596, 3600, 3604, 3608, 3612, 3616, 3620, 3624, 3628, 3632, 3636, 3640, 3644, 3648,
		3652, 3656, 3660, 3664, 3668, 3672, 3676, 3680, 3684, 3688, 3692, 3696, 3700, 3704, 3708, 3712, 3716, 3720, 3724, 3728,
		3732, 3736, 3740, 3744, 3748, 3752, 3756, 3760, 3764, 3768, 3772, 3776, 3780, 3784, 3788, 3792, 3796, 3800, 3804, 3808,
		3812, 3816, 3820, 3824, 3828, 3832, 3836, 3840, 3844, 3848, 3852, 3856, 3860, 3864, 3868, 3872, 3876, 3880, 3884, 3888,
		3892, 3896, 3900, 3904, 3908, 3912, 3916, 3920, 3924, 3928, 3932, 3936, 3940, 3944, 3948, 3952, 3956, 3960, 3964, 3968,
		3972, 3976, 3980, 3984, 3988, 3992, 3996, 4000, 4004, 4008, 4012, 4016, 4020, 4024, 4029, 4033, 4038, 4043, 4047, 4052,
		4057, 4061, 4066, 4070, 4075, 4080, 4084, 4089, 4094, 4098, 4103, 4107, 4112, 4117, 4121, 4126, 4131, 4135, 4140, 4144,
		4149, 4154, 4158, 4163, 4168, 4172, 4177, 4181, 4186, 4191, 4195, 4200, 4205, 4209, 4214, 4218, 4223, 4228, 4232, 4237,
		4242, 4246, 4251, 4255, 4260, 4265, 4269, 4274, 4279, 4283, 4288, 4292, 4297, 4302, 4306, 4311, 4316, 4321, 4326, 4331,
		4336, 4341, 4346, 4351, 4356, 4361, 4366, 4371, 4376, 4381, 4386, 4391, 4396, 4401, 4406, 4411, 4416, 4421, 4426, 4431,
		4436, 4441, 4446, 4451, 4456, 4461, 4466, 4471, 4476, 4481, 4486, 4491, 4496, 4501, 4506, 4511, 4516, 4521, 4526, 4531,
		4536, 4541, 4546, 4551, 4556, 4561, 4566, 4571, 4576, 4581, 4586, 4591, 4596, 4601, 4606, 4611, 4616, 4621, 4626, 4631,
		4636, 4641, 4646, 4651, 4656, 4661, 4666, 4671, 4676, 4681, 4686, 4691, 4696, 4701, 4706, 4711, 4716, 4721, 4726, 4731,
		4736, 4741, 4746, 4751, 4756, 4761, 4766, 4771, 4776, 4781, 4786, 4791, 4796, 4801, 4806, 4811, 4816, 4821, 4826, 4831,
		4836, 4841, 4846, 4851, 4856, 4861, 4866, 4871, 4876, 4881, 4886, 4891, 4896, 4901, 4906, 4911, 4916, 4921, 4926, 4931,
		4936, 4941, 4946, 4951, 4956, 4961, 4966, 4971, 4976, 4981, 4986, 4991, 4996, 5001, 5006, 5011, 5016, 5021, 5026, 5031,
		5036, 5041, 5046, 5051, 5056, 5061, 5066, 5071, 5076, 5081, 5086, 5091, 5096, 5101, 5106, 5111, 5116, 5121, 5126, 5131,
		5136, 5141, 5146, 5151, 5156, 5161, 5166, 5171, 5176, 5181, 5186, 5191, 5196, 5201, 5206, 5211, 5216, 5221, 5226, 5231,
		5236, 5241, 5246, 5251, 5256, 5261, 5266, 5271, 5276, 5281, 5286, 5291, 5296, 5301, 5307, 5312, 5317, 5322, 5327, 5333,
		5338, 5343, 5348, 5353, 5359, 5364, 5369, 5374, 5379, 5384, 5390, 5395, 5400, 5405, 5410, 5416, 5421, 5426, 5431, 5436,
		5442, 5447, 5452, 5457, 5462, 5467, 5473, 5478, 5483, 5488, 5493, 5499, 5504, 5509, 5514, 5519, 5525, 5530, 5535, 5540,
		5545, 5550, 5556, 5561, 5566, 5571, 5576, 5582, 5587, 5592, 5597, 5602, 5608, 5614, 5620, 5626, 5632, 5638, 5644, 5650,
		5656, 5662, 5668, 5674, 5680, 5686, 5692, 5698, 5704, 5710, 5716, 5722, 5728, 5734, 5740, 5746, 5752, 5758, 5764, 5770,
		5776, 5782, 5788, 5794, 5800, 5806, 5812, 5818, 5824, 5830, 5836, 5842, 5848, 5854, 5860, 5866, 5872, 5878, 5884, 5890,
		5896, 5902, 5908, 5914, 5920, 5926, 5932, 5938, 5944, 5950, 5956, 5962, 5968, 5974, 5980, 5986, 5992, 5998, 6004, 6010,
		6016, 6022, 6028, 6034, 6040, 6046, 6052, 6058, 6064, 6070, 6076, 6082, 6088, 6094, 6100, 6106, 6112, 6118, 6124, 6130,
		6136, 6142, 6148, 6154, 6160, 6166, 6172, 6178, 6184, 6190, 6196, 6202, 6208, 6214, 6220, 6226, 6232, 6238, 6244, 6250,
		6256, 6262, 6268, 6274, 6280, 6286, 6292, 6298, 6304, 6310, 6316, 6322, 6328, 6334, 6340, 6346, 6352, 6358, 6364, 6370,
		6376, 6382, 6388, 6394, 6400, 6406, 6412, 6418, 6424, 6430, 6436, 6442, 6448, 6454, 6460, 6466, 6472, 6478, 6484, 6490,
		6496, 6502, 6508, 6514, 6520, 6526, 6532, 6538, 6544, 6550, 6556, 6562, 6568, 6574, 6580, 6586, 6592, 6598, 6604, 6610,
		6616, 6622, 6628, 6634, 6640, 6646, 6652, 6658, 6664, 6670, 6676, 6682, 6688, 6694, 6700, 6706, 6712, 6718, 6724, 6730,
		6736, 6742, 6748, 6754, 6760, 6766, 6772, 6778, 6784, 6790, 6796, 6802, 6808, 6814, 6820, 6826, 6832, 6838, 6844, 6850,
		6857, 6863, 6869, 6875, 6881, 6887, 6893, 6899, 6905, 6911, 6917, 6923, 6929, 6935, 6941, 6947, 6954, 6960, 6966, 6972,
		6978, 6984, 6990, 6996, 7002, 7008, 7014, 7020, 7026, 7032, 7038, 7044, 7051, 7057, 7063, 7069, 7075, 7081, 7087, 7093,
		7099, 7105, 7111, 7117, 7123, 7129, 7135, 7141, 7148, 7155, 7162, 7169, 7176, 7183, 7190, 7197, 7204, 7211, 7218, 7225,
		7232, 7239, 7246, 7253, 7260, 7267, 7274, 7281, 7288, 7295, 7302, 7309, 7316, 7323, 7330, 7337, 7344, 7351, 7358, 7365,
		7372, 7379, 7386, 7393, 7400, 7407, 7414, 7421, 7428, 7435, 7442, 7449, 7456, 7463, 7470, 7477, 7484, 7491, 7498, 7505,
		7512, 7519, 7526, 7533, 7540, 7547, 7554, 7561, 7568, 7575, 7582, 7589, 7596, 7603, 7610, 7617, 7624, 7631, 7638, 7645,
		7652, 7659, 7666, 7673, 7680, 7687, 7694, 7701, 7708, 7715, 7722, 7729, 7736, 7743, 7750, 7757, 7764, 7771, 7778, 7785,
		7792, 7799, 7806, 7813, 7820, 7827, 7834, 7841, 7848, 7855, 7862, 7869, 7876, 7883, 7890, 7897, 7904, 7911, 7918, 7925,
		7932, 7939, 7946, 7953, 7960, 7967, 7974, 7981, 7988, 7995, 8002, 8009, 8016, 8023, 8030, 8037, 8044, 8051, 8058, 8065,
		8072, 8079, 8086, 8093, 8100, 8107, 8114, 8121, 8128, 8135, 8142, 8149, 8156, 8163, 8170, 8177, 8184, 8191, 8198, 8205,
		8212, 8219, 8226, 8233, 8240, 8247, 8254, 8261, 8268, 8275, 8282, 8289, 8296, 8303, 8310, 8317, 8324, 8331, 8338, 8345,
		8352, 8359, 8366, 8373, 8380, 8387, 8394, 8401, 8408, 8415, 8422, 8429, 8436, 8443, 8450, 8457, 8464, 8471, 8478, 8485,
		8492, 8499, 8506, 8513, 8520, 8527, 8534, 8541, 8548, 8555, 8562, 8569, 8576, 8583, 8590, 8597, 8604, 8611, 8618, 8625,
		8632, 8639, 8646, 8653, 8660, 8667, 8674, 8681, 8688, 8695, 8702, 8709, 8716, 8723, 8730, 8737, 8744, 8751, 8758, 8765,
		8772, 8779, 8786, 8793, 8800, 8807, 8814, 8821, 8828, 8835, 8842, 8849, 8856, 8863, 8870, 8877, 8884, 8891, 8898, 8905,
		8912, 8919, 8926, 8933, 8940, 8948, 8956, 8964, 8972, 8980, 8988, 8996, 9004, 9012, 9020, 9028, 9036, 9044, 9052, 9060,
		9068, 9076, 9084, 9092, 9100, 9108, 9116, 9124, 9132, 9140, 9148, 9156, 9164, 9172, 9180, 9188, 9196, 9204, 9212, 9220,
		9228, 9236, 9244, 9252, 9260, 9268, 9276, 9284, 9292, 9300, 9308, 9316, 9324, 9332, 9340, 9348, 9356, 9364, 9372, 9380,
		9388, 9396, 9404, 9412, 9420, 9428, 9436, 9444, 9452, 9460, 9468, 9476, 9484, 9492, 9500, 9508, 9516, 9524, 9532, 9540,
		9548, 9556, 9564, 9572, 9580, 9588, 9596, 9604, 9612, 9620, 9628, 9636, 9644, 9652, 9660, 9668, 9676, 9684, 9692, 9700,
		9708, 9716, 9724, 9732, 9740, 9748, 9756, 9764, 9772, 9780, 9788, 9796, 9804, 9812, 9820, 9828, 9836, 9844, 9852, 9860,
		9868, 9876, 9884, 9892, 9900, 9908, 9916, 9924, 9932, 9940, 9948, 9956, 9964, 9972, 9980, 9988, 9996, 10004, 10012, 10020,
		10028, 10036, 10044, 10052, 10060, 10068, 10076, 10084, 10092, 10100, 10108, 10116, 10124, 10132, 10140, 10148, 10156, 10164, 10172, 10180,
		10188, 10196, 10204, 10212, 10220, 10228, 10236, 10244, 10252, 10260, 10268, 10276, 10284, 10292, 10300, 10308, 10316, 10324, 10332, 10340,
		10348, 10356, 10364, 10372, 10380, 10388, 10396, 10404, 10412, 10420, 10428, 10436, 10444, 10452, 10460, 10468, 10476, 10484, 10492, 10500,
		10508, 10516, 10524, 10532, 10540, 10548, 10556, 10564, 10572, 10580, 10588, 10596, 10604, 10612, 10620, 10628, 10636, 10644, 10652, 10660,
		10668, 10676, 10684, 10692, 10700, 10708, 10716, 10724, 10732, 10740, 10748, 10756, 10764, 10772, 10780, 10788, 10796, 10804, 10812, 10820,
		10828, 10836, 10844, 10852, 10860, 10868, 10876, 10884, 10892, 10900, 10908, 10916, 10924, 10932, 10940, 10948, 10956, 10964, 10972, 10980,
		10988, 10997, 11006, 11015, 11024, 11033, 11042, 11051, 11060, 11069, 11078, 11087, 11096, 11105, 11114, 11123, 11132, 11141, 11150, 11159,
		11168, 11177, 11186, 11195, 11204, 11213, 11222, 11231, 11240, 11249, 11258, 11267, 11276, 11285, 11294, 11303, 11312, 11321, 11330, 11339,
		11348, 11357, 11366, 11375, 11384, 11393, 11402, 11411, 11420, 11429, 11438, 11447, 11456, 11465, 11474, 11483, 11492, 11501, 11510, 11519,
		11528, 11537, 11546, 11555, 11564, 11573, 11582, 11591, 11600, 11609, 11618, 11627, 11636, 11645, 11654, 11663, 11672, 11681, 11690, 11699,
		11708, 11717, 11726, 11735, 11744, 11753, 11762, 11771, 11780, 11789, 11798, 11807, 11816, 11825, 11834, 11843, 11852, 11861, 11870, 11879,
		11888, 11897, 11906, 11915, 11924, 11933, 11942, 11951, 11960, 11969, 11978, 11987, 11996, 12005, 12014, 12023, 12032, 12041, 12050, 12059,
		12068, 12077, 12086, 12095, 12104, 12113, 12122, 12131, 12140, 12149, 12158, 12167, 12176, 12185, 12194, 12203, 12212, 12221, 12230, 12239,
		12248, 12257, 12266, 12275, 12284, 12293, 12302, 12311, 12320, 12329, 12338, 12347, 12356, 12365, 12374, 12383, 12392, 12401, 12410, 12419,
		12428, 12437, 12446, 12455, 12464, 12473, 12482, 12491, 12500, 12509, 12518, 12527, 12536, 12545, 12554, 12563, 12572, 12581, 12590, 12599,
		12608, 12617, 12626, 12635, 12644, 12653, 12662, 12671, 12680, 12689, 12698, 12707, 12716, 12725, 12734, 12743, 12752, 12761, 12770, 12779,
		12788, 12797, 12806, 12815, 12824, 12833, 12842, 12851, 12860, 12869, 12878, 12887, 12896, 12905, 12914, 12923, 12932, 12941, 12950, 12959,
		12968, 12977, 12986, 12995, 13004, 13013, 13022, 13031, 13040, 13049, 13058, 13067, 13076, 13085, 13094, 13103, 13112, 13121, 13130, 13139,
		13148, 13157, 13166, 13175, 13184, 13193, 13202, 13211, 13220, 13229, 13238, 13247, 13256, 13265, 13274, 13283, 13292, 13301, 13311, 13321,
		13331, 13341, 13351, 13361, 13371, 13381, 13391, 13401, 13411, 13421, 13431, 13441, 13451, 13460, 13470, 13480, 13490, 13500, 13510, 13520,
		13530, 13540, 13550, 13560, 13570, 13580, 13590, 13600, 13610, 13619, 13629, 13639, 13649, 13659, 13669, 13679, 13689, 13699, 13709, 13719,
		13729, 13739, 13749, 13759, 13769, 13778, 13788, 13798, 13808, 13818, 13828, 13838, 13848, 13858, 13868, 13878, 13888, 13898, 13908, 13918,
		13928, 13938, 13948, 13958, 13968, 13978, 13988, 13998, 14008, 14018, 14028, 14038, 14048, 14058, 14068, 14078, 14088, 14098, 14108, 14118,
		14128, 14138, 14148, 14158, 14168, 14178, 14188, 14198, 14208, 14218, 14228, 14238, 14248, 14258, 14268, 14278, 14288, 14298, 14308, 14318,
		14328, 14338, 14348, 14358, 14368, 14378, 14388, 14398, 14408, 14418, 14428, 14438, 14448, 14458, 14468, 14478, 14488, 14498, 14508, 14518,
		14528, 14538, 14548, 14558, 14568, 14577, 14587, 14597, 14607, 14617, 14627, 14637, 14647, 14656, 14666, 14676, 14686, 14696, 14706, 14716,
		14726, 14735, 14745, 14755, 14765, 14775, 14785, 14795, 14805, 14814, 14824, 14834, 14844, 14854, 14864, 14874, 14884, 14893, 14903, 14913,
		14923, 14933, 14943, 14953, 14963, 14972, 14982, 14992, 15002, 15012, 15022, 15032, 15042, 15051, 15061, 15071, 15081, 15091, 15101, 15111,
		15121, 15130, 15140, 15150, 15160, 15170, 15180, 15190, 15200, 15210, 15221, 15232, 15243, 15254, 15265, 15276, 15287, 15298, 15309, 15320,
		15331, 15342, 15353, 15364, 15375, 15385, 15396, 15407, 15418, 15429, 15440, 15451, 15462, 15473, 15484, 15495, 15506, 15517, 15528, 15539,
		15550, 15560, 15571, 15582, 15593, 15604, 15615, 15626, 15637, 15648, 15659, 15670, 15681, 15692, 15703, 15714, 15725, 15735, 15746, 15757,
		15768, 15779, 15790, 15801, 15812, 15823, 15834, 15845, 15856, 15867, 15878, 15889, 15900, 15907, 15915, 15922, 15930, 15937, 15945, 15952,
		15960, 15967, 15975, 15982, 15990, 15997, 16005, 16012, 16020, 16027, 16035, 16042, 16050, 16057, 16065, 16072, 16080, 16087, 16095, 16102,
		16110, 16117, 16125, 16132, 16140, 16147, 16155, 16162, 16170, 16177, 16185, 16192, 16200, 16207, 16215, 16222, 16230, 16237, 16245, 16252,
		16260, 16267, 16275, 16282, 16290, 16297, 16305, 16312, 16320, 16327, 16335, 16342, 16350, 16357, 16365, 16372, 16380, 16383
	};

	uint16 lut3[769] = {
		0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
		20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
		40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
		60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
		80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
		100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 115, 117, 119, 121, 123, 125,
		127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 155, 157, 159, 161, 163, 165,
		167, 169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197, 199, 201, 203, 205,
		207, 209, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237, 239, 241, 243, 245,
		247, 249, 251, 253, 256, 258, 260, 262, 264, 266, 268, 270, 273, 276, 279, 282, 285, 288, 291, 294,
		297, 300, 303, 306, 309, 312, 315, 318, 321, 324, 327, 330, 333, 336, 339, 342, 345, 348, 351, 354,
		357, 360, 363, 366, 369, 372, 375, 378, 381, 384, 387, 390, 393, 396, 399, 402, 405, 408, 411, 414,
		417, 420, 423, 426, 429, 432, 435, 438, 441, 444, 447, 450, 453, 456, 459, 462, 465, 468, 472, 476,
		479, 483, 487, 490, 494, 498, 501, 505, 509, 512, 516, 520, 524, 528, 532, 536, 540, 544, 548, 552,
		556, 560, 564, 568, 572, 576, 580, 584, 588, 592, 596, 600, 604, 608, 612, 616, 620, 624, 628, 632,
		636, 640, 644, 648, 652, 656, 660, 664, 668, 672, 676, 680, 684, 688, 692, 696, 700, 704, 708, 712,
		716, 720, 724, 729, 733, 737, 742, 746, 751, 755, 759, 764, 768, 772, 777, 781, 786, 791, 796, 801,
		806, 811, 816, 821, 826, 831, 836, 841, 846, 851, 856, 861, 866, 871, 876, 881, 886, 891, 896, 901,
		906, 911, 916, 921, 926, 931, 936, 941, 946, 951, 956, 961, 966, 971, 976, 981, 986, 991, 996, 1001,
		1006, 1011, 1016, 1021, 1026, 1031, 1036, 1041, 1046, 1051, 1057, 1062, 1067, 1072, 1077, 1083, 1088, 1093, 1098, 1103,
		1109, 1115, 1121, 1127, 1133, 1139, 1145, 1151, 1157, 1163, 1169, 1175, 1181, 1187, 1193, 1199, 1205, 1211, 1217, 1223,
		1229, 1235, 1241, 1247, 1253, 1259, 1265, 1271, 1277, 1283, 1289, 1295, 1301, 1307, 1313, 1319, 1325, 1331, 1337, 1343,
		1349, 1355, 1361, 1367, 1373, 1379, 1385, 1391, 1397, 1403, 1409, 1415, 1421, 1427, 1433, 1439, 1445, 1451, 1457, 1463,
		1469, 1475, 1481, 1487, 1494, 1501, 1508, 1515, 1522, 1529, 1536, 1543, 1550, 1557, 1564, 1571, 1578, 1585, 1592, 1599,
		1606, 1613, 1620, 1627, 1634, 1641, 1648, 1655, 1662, 1669, 1676, 1683, 1690, 1697, 1704, 1711, 1718, 1725, 1732, 1739,
		1746, 1753, 1760, 1767, 1774, 1781, 1788, 1795, 1802, 1809, 1816, 1823, 1830, 1837, 1844, 1851, 1858, 1865, 1872, 1879,
		1886, 1893, 1900, 1907, 1914, 1921, 1928, 1935, 1942, 1949, 1957, 1965, 1973, 1981, 1989, 1997, 2005, 2013, 2021, 2029,
		2037, 2045, 2053, 2061, 2069, 2077, 2085, 2093, 2101, 2109, 2117, 2125, 2133, 2141, 2149, 2157, 2165, 2173, 2181, 2189,
		2197, 2205, 2213, 2221, 2229, 2237, 2245, 2253, 2261, 2269, 2277, 2285, 2293, 2301, 2309, 2317, 2325, 2333, 2341, 2349,
		2357, 2365, 2373, 2381, 2389, 2397, 2405, 2413, 2421, 2429, 2437, 2445, 2453, 2461, 2470, 2479, 2488, 2497, 2506, 2515,
		2524, 2533, 2542, 2551, 2560, 2569, 2578, 2587, 2596, 2605, 2614, 2623, 2632, 2641, 2650, 2659, 2668, 2677, 2686, 2695,
		2704, 2713, 2722, 2731, 2740, 2749, 2758, 2767, 2776, 2785, 2794, 2803, 2812, 2821, 2830, 2839, 2848, 2857, 2866, 2875,
		2884, 2893, 2902, 2911, 2920, 2929, 2938, 2947, 2956, 2965, 2974, 2983, 2992, 3001, 3010, 3019, 3028, 3037, 3047, 3057,
		3067, 3077, 3087, 3097, 3107, 3116, 3126, 3136, 3146, 3156, 3166, 3176, 3186, 3196, 3206, 3216, 3226, 3236, 3246, 3256,
		3266, 3276, 3286, 3296, 3306, 3316, 3326, 3336, 3346, 3356, 3366, 3376, 3386, 3396, 3406, 3416, 3426, 3436, 3446, 3456,
		3466, 3476, 3486, 3496, 3506, 3516, 3526, 3536, 3546, 3556, 3566, 3576, 3586, 3596, 3606, 3616, 3626, 3636, 3646, 3656,
		3666, 3676, 3687, 3698, 3709, 3720, 3731, 3742, 3753, 3763, 3774, 3785, 3796, 3807, 3818, 3829, 3840, 3851, 3862, 3873,
		3884, 3895, 3906, 3917, 3928, 3939, 3950, 3961, 3972, 3983, 3994, 4005, 4016, 4020, 4025, 4030, 4035, 4040, 4045, 4050,
		4055, 4060, 4065, 4070, 4075, 4080, 4085, 4090, 4095
	};

	int i;
	for (i = 0; i < 16384; i++)
	{
		mCorrectionTable1[i] = correctionTable1[i];
		mCorrectionTable2[i] = correctionTable2[i];
	}
	for (i = 0; i < 4096; i++)
	{
		mCorrectionTable3[i] = correctionTable3[i];
	}
	for (i = 0; i < 3073; i++)
	{
		mLut1[i] = lut1[i];
	}
	for (i = 0; i < 4098; i++)
	{
		mLut2[i] = lut2[i];
	}
	for (i = 0; i < 769; i++)
	{
		mLut3[i] = lut3[i];
	}
}