// NikonRemoveRings.cpp : implementation file
//

#include "stdafx.h"
#include "NikonRemoveRings.h"
#include "NikonRemoveRingsDlg.h"

//#include "dng_camera_profile.h"
//#include "dng_color_space.h"
//#include "dng_date_time.h"
//#include "dng_exceptions.h"
//#include "dng_file_stream.h"
//#include "dng_globals.h"
//#include "dng_host.h"
//#include "dng_ifd.h"
//#include "dng_image_writer.h"
//#include "dng_info.h"
//#include "dng_linearization_info.h"
//#include "dng_mosaic_info.h"
//#include "dng_negative.h"
//#include "dng_preview.h"
//#include "dng_render.h"
//#include "dng_simple_image.h"
//#include "dng_tag_codes.h"
//#include "dng_tag_types.h"
//#include "dng_tag_values.h"
//#include "dng_xmp.h"
//#include "dng_xmp_sdk.h"

#include "CorrectDng.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:



	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNikonRemoveRings dialog

CNikonRemoveRings::CNikonRemoveRings(CWnd* pParent /*=NULL*/)
	: CDialog(CNikonRemoveRings::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNikonRemoveRings)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNikonRemoveRings::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNikonRemoveRings)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNikonRemoveRings, CDialog)
	//{{AFX_MSG_MAP(CNikonRemoveRings)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_IP_FOLDER, OnButton_IP_Folder)
	ON_BN_CLICKED(IDC_BUTTON_OP_FOLDER, OnButton_OP_Folder)
	ON_BN_CLICKED(ID_BUTTON_CONVERT, OnButton_Convert)
	ON_BN_CLICKED(IDC_CHECK_SKIP_CONVERSION, OnButton_SkipConversion)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNikonRemoveRings message handlers

BOOL CNikonRemoveRings::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CWnd* pWnd;
	pWnd = this->GetDlgItem(IDC_STATIC_IP_FOLDER);
	pWnd->SetWindowText(L"No folder selected");
	pWnd = this->GetDlgItem(IDC_STATIC_OP_FOLDER);
	pWnd->SetWindowText(L"No folder selected");
	pWnd = this->GetDlgItem(IDC_STATIC_PROGRESS);
	pWnd->SetWindowText(L"No progress information");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNikonRemoveRings::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNikonRemoveRings::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNikonRemoveRings::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNikonRemoveRings::OnButton_IP_Folder()
{
	CString strFilter;
	HRESULT hResult;
	strFilter = "DNG(*.dng)|*.dng||";

	CFileDialog dlg(TRUE, NULL, NULL, OFN_FILEMUSTEXIST, strFilter);
	dlg.m_ofn.nFilterIndex = 1;
	hResult = (int)dlg.DoModal();
	if(FAILED(hResult)) {
		return;
	}

	if (hResult == IDOK)
	{
		mInputFolder = dlg.GetFolderPath();
		CWnd* pWnd;
		pWnd = this->GetDlgItem(IDC_STATIC_IP_FOLDER);
		pWnd->SetWindowText(mInputFolder);
		isIPFolder = true;
	}
}

void CNikonRemoveRings::OnButton_OP_Folder()
{
	CString strFilter;
	HRESULT hResult;
	
	CFolderPickerDialog dlg(NULL, NULL, NULL, 0);
	hResult = (int)dlg.DoModal();
	if (FAILED(hResult)) {
		return;
	}

	if (hResult == IDOK)
	{
		mOutputFolder = dlg.GetFolderPath();
		CWnd* pWnd;
		pWnd = this->GetDlgItem(IDC_STATIC_OP_FOLDER);
		pWnd->SetWindowText(mOutputFolder);
		isOPFolder = true;
	}
	
}

void CNikonRemoveRings::OnButton_SkipConversion()
{
	CWnd* pWnd;
	pWnd = this->GetDlgItem(IDC_CHECK_SKIP_CONVERSION);
	CButton* pBut = (CButton*)pWnd;

	isSkip = (bool) pBut->GetCheck();
}

void CNikonRemoveRings::OnButton_Convert()
{



	if (!isIPFolder)
	{
		MessageBox(L"Please select location of raw files", L"Error");
		return;
	}
	if (!isOPFolder)
	{
		MessageBox(L"Please select location for converted files", L"Error");
		return;
	}

	//Disable the buttons i.e. gray them out
	CWnd* pWnd;
	pWnd = this->GetDlgItem(IDC_BUTTON_IP_FOLDER);
	pWnd->EnableWindow(FALSE);
	pWnd = this->GetDlgItem(IDC_BUTTON_OP_FOLDER);
	pWnd->EnableWindow(FALSE);
	pWnd = this->GetDlgItem(ID_BUTTON_CONVERT);
	pWnd->EnableWindow(FALSE);

	//Create list of files to convert
	CStringArray& files = *(new CStringArray);
	CStringArray& fileTitles = *(new CStringArray);
	CFileFind finder;
	BOOL bWorking = finder.FindFile(mInputFolder+"\\*.dng");
	while (bWorking)
	{
		bWorking = finder.FindNextFile();

		// skip . and .. files
		if (!finder.IsDots())
		{
			files.Add(finder.GetFilePath());
			fileTitles.Add(finder.GetFileTitle()); //Title has no extension
		}
	}

	int processCount = 0;
	int skipCount = 0;

	CorrectDng correctDng;

	for (int i = 0; i < files.GetCount(); i++)
	{
		//Check if Exit button has been pressed
		MSG msg;
		if (PeekMessage(&msg, this->GetDlgItem(IDCANCEL)->m_hWnd, WM_LBUTTONDOWN, WM_LBUTTONDOWN, PM_NOREMOVE))
			return;

		CString filepath_in = files.ElementAt(i);
		CString fileTitle = fileTitles.ElementAt(i);

		CString filepath_out = mOutputFolder +"\\"+ fileTitle + "_fix.dng";
		DWORD attr = GetFileAttributes(filepath_out);
		bool doesExist = true;
		if (attr == INVALID_FILE_ATTRIBUTES)
			doesExist = false;

		CString count;
		count.Format(L"%d", i + 1);
		CString total;
		total.Format(L"%d", files.GetCount());
		CString status = "File " + count + " of " + total + ":    " + fileTitle + ".dng -> " + fileTitle + "_fix.dng";
		CWnd* pWnd;
		pWnd = this->GetDlgItem(IDC_STATIC_PROGRESS);
		pWnd->SetWindowText(status);

		if (doesExist && isSkip)
		{
			skipCount++;
			continue;
		}

		if (!correctDng.ApplyCorrection((CWnd*) this, filepath_in, filepath_out))
		{
			//Re-enable the buttons
			pWnd = this->GetDlgItem(IDC_BUTTON_IP_FOLDER);
			pWnd->EnableWindow(TRUE);
			pWnd = this->GetDlgItem(IDC_BUTTON_OP_FOLDER);
			pWnd->EnableWindow(TRUE);
			pWnd = this->GetDlgItem(ID_BUTTON_CONVERT);
			pWnd->EnableWindow(TRUE);

			return;
		}
		processCount++;
	}

	CString processed;
	processed.Format(L"%d", processCount);
	CString skipped;
	skipped.Format(L"%d", skipCount);
	CString status = "Processing Complete!  " + processed + " files converted.   " + skipped + " files skipped.";

	pWnd = this->GetDlgItem(IDC_STATIC_PROGRESS);
	pWnd->SetWindowText(status);

	//Re-enable the buttons
	pWnd = this->GetDlgItem(IDC_BUTTON_IP_FOLDER);
	pWnd->EnableWindow(TRUE);
	pWnd = this->GetDlgItem(IDC_BUTTON_OP_FOLDER);
	pWnd->EnableWindow(TRUE);
	pWnd = this->GetDlgItem(ID_BUTTON_CONVERT);
	pWnd->EnableWindow(TRUE);

	delete(&files);
	delete(&fileTitles);
	return;
}




